/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.RelatedDataSetGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.RelatedDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.core.XDOM;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public final class ShowRelatedDatasetsDialog<E extends IEntityInformationHolder>
extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<E>>> {
    private static final int FIELD_WIDTH = 200;
    private static final int LABEL_WIDTH = 120;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final TableExportCriteria<TableModelRowWithObject<E>> displayedEntities;
    private final int displayedEntitiesCount;
    private Radio allOrSelectedRadio;

    public static <E extends IEntityInformationHolder> void showRelatedDatasetsTab(final IViewContext<ICommonClientServiceAsync> viewContext, final RelatedDataSetCriteria<E> criteria) {
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = RelatedDataSetGrid.create(viewContext, criteria);
                return DefaultTabItem.create(this.getTabTitle(), component, viewContext);
            }

            @Override
            public String getId() {
                return "openbis_related-data-set-browser" + XDOM.getUniqueId();
            }

            @Override
            public String getTabTitle() {
                return "Related Data Sets";
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.RELATED_DATA_SETS, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    public ShowRelatedDatasetsDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<TableModelRowWithObject<E>> selectedEntities, TableExportCriteria<TableModelRowWithObject<E>> displayedEntities, int displayedEntitiesCount) {
        super(viewContext, selectedEntities, viewContext.getMessage("show_related_datasets", new Object[0]));
        this.viewContext = viewContext;
        this.displayedEntities = displayedEntities;
        this.displayedEntitiesCount = displayedEntitiesCount;
        this.setWidth(370);
    }

    @Override
    protected String createMessage() {
        return this.viewContext.getMessage("show_related_datasets_message", ((List)this.data).size());
    }

    @Override
    protected final void extendForm() {
        this.formPanel.setLabelWidth(120);
        this.formPanel.setFieldWidth(200);
        this.formPanel.setBodyBorder(false);
        this.formPanel.setHeaderVisible(false);
        this.formPanel.add((Widget)this.createAllOrSelectedRadio());
    }

    private final RadioGroup createAllOrSelectedRadio() {
        String radioGroupLabel = this.viewContext.getMessage("show_related_datasets_radio_label", new Object[0]);
        String selectedLabel = this.viewContext.getMessage("only_selected_radio", ((List)this.data).size());
        String allLabel = this.viewContext.getMessage("all_radio", this.displayedEntitiesCount);
        this.allOrSelectedRadio = WidgetUtils.createRadio(selectedLabel);
        return WidgetUtils.createAllOrSelectedRadioGroup(this.allOrSelectedRadio, WidgetUtils.createRadio(allLabel), radioGroupLabel, ((List)this.data).size());
    }

    private boolean getSelected() {
        return WidgetUtils.isSelected(this.allOrSelectedRadio);
    }

    @Override
    protected void executeConfirmedAction() {
        boolean selected = this.getSelected();
        RelatedDataSetCriteria<E> criteria = this.createCriteria(selected);
        ShowRelatedDatasetsDialog.showRelatedDatasetsTab(this.viewContext, criteria);
    }

    private RelatedDataSetCriteria<E> createCriteria(boolean selected) {
        if (this.getSelected()) {
            return RelatedDataSetCriteria.createSelectedEntities((List)this.data);
        }
        return RelatedDataSetCriteria.createDisplayedEntities(this.displayedEntities);
    }
}

