/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Header;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

public abstract class TabContent
extends ContentPanel {
    protected final IViewContext<?> viewContext;
    private String displayId;
    private boolean isContentVisible = false;
    private boolean autoDisposeComponents = true;
    private String parentDisplayID;
    private final String ownerId;

    protected abstract void showContent();

    public TabContent(String header, IViewContext<?> viewContext, IIdHolder ownerOrNull) {
        this(header, viewContext, ownerOrNull != null ? ownerOrNull.getId().toString() : "");
    }

    private TabContent(String header, IViewContext<?> viewContext, String ownerId) {
        this.viewContext = viewContext;
        this.ownerId = ownerId;
        this.setHeading(header);
        this.setHeaderVisible(true);
        this.setCollapsible(false);
        this.setAnimCollapse(false);
        this.setBodyBorder(true);
        this.setLayout((Layout)new FitLayout());
    }

    public String getParentDisplayID() {
        return this.parentDisplayID;
    }

    public void setParentDisplayID(String parentDisplayID) {
        this.parentDisplayID = parentDisplayID;
    }

    public void setIds(IDisplayTypeIDGenerator generator) {
        this.setId(TabContent.createId(this.ownerId, generator));
        this.displayId = generator.createID();
    }

    public static String createId(String ownerId, IDisplayTypeIDGenerator generator) {
        return "openbis_" + ownerId + "-" + generator.createID();
    }

    public String getDisplayID() {
        if (this.displayId == null) {
            throw new IllegalStateException("Undefined display ID");
        }
        return this.displayId;
    }

    public void setContentVisible(boolean visible) {
        if (visible && !this.isContentVisible) {
            this.showContent();
            Header h = this.getHeader();
            if (h.getToolCount() > 0) {
                h.show();
            } else {
                h.hide();
            }
            this.syncSize();
            this.isContentVisible = true;
        }
    }

    public boolean isContentVisible() {
        return this.isContentVisible;
    }

    public void disableAutoDisposeComponents() {
        this.autoDisposeComponents = false;
    }

    protected boolean isAutoDisposeComponents() {
        return this.autoDisposeComponents;
    }

    protected void onDetach() {
        if (this.isAutoDisposeComponents()) {
            this.disposeComponents();
        }
        super.onDetach();
    }

    public void disposeComponents() {
    }
}

