/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.SetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompositeDatabaseModificationObserver
implements IDatabaseModificationObserver {
    protected final List<IDatabaseModificationObserver> registeredObservers = new ArrayList<IDatabaseModificationObserver>();

    public void addObservers(List<? extends IDatabaseModificationObserver> observers) {
        for (IDatabaseModificationObserver iDatabaseModificationObserver : observers) {
            this.addObserver(iDatabaseModificationObserver);
        }
    }

    public void addObserver(IDatabaseModificationObserver observerOrNull) {
        if (observerOrNull != null) {
            this.registeredObservers.add(observerOrNull);
        }
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        HashSet relevantModifications = new HashSet();
        for (IDatabaseModificationObserver observer : this.registeredObservers) {
            SetUtils.addAll(relevantModifications, observer.getRelevantModifications());
        }
        return relevantModifications.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        for (IDatabaseModificationObserver observer : this.registeredObservers) {
            if (!SetUtils.containsAny(observedModifications, observer.getRelevantModifications())) continue;
            observer.update(observedModifications);
        }
    }
}

