/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.framework;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.GenericConstants;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AppEvents;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IMainPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.WelcomePanelHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.ConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MenuEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.event.TabPanelEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.google.gwt.http.client.URL;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MainTabPanel
extends TabPanel
implements IMainPanel {
    private static final String PREFIX = "openbis_main-tab-panel_";
    public static final String TAB_SUFFIX = "_tab";
    public static final String BLANK_TAB_TITLE = "&nbsp;";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    public static final String ID = "openbis_main-tab-panel_".substring(0, "openbis_main-tab-panel_".length() - 1);
    private final Map<String, MainTabItem> openTabs = new HashMap<String, MainTabItem>();
    private MenuItem helpMenuItem;
    private MenuItem bookmarkMenuItem;

    MainTabPanel(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
        this.setTabScroll(true);
        this.setId(ID);
        this.setCloseContextMenu(true);
        this.setPlain(true);
        this.setBodyBorder(false);
        this.setBorders(false);
        this.setBorderStyle(false);
        this.add(this.createWelcomePanel());
    }

    private final MainTabItem createWelcomePanel() {
        final LayoutContainer mainComponent = new LayoutContainer((Layout)new FitLayout());
        ITabItem tabItem = DefaultTabItem.createWithUpdater(BLANK_TAB_TITLE, (Component)mainComponent, new IDelegatedAction(){

            @Override
            public void execute() {
                mainComponent.removeAll();
                mainComponent.add((Widget)WelcomePanelHelper.createWelcomePanel(MainTabPanel.this.viewContext, MainTabPanel.PREFIX));
                mainComponent.layout();
            }
        }, this.viewContext);
        MainTabItem intro = new MainTabItem(tabItem, mainComponent.getId(), null, null);
        intro.setIcon(AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getHomeIcon()));
        intro.setClosable(false);
        return intro;
    }

    private final MainTabItem tryFindTab(AbstractTabItemFactory tabItemFactory) {
        return this.openTabs.get(tabItemFactory.getId());
    }

    private final int getTabPosition(MainTabItem tabItem) {
        return this.getItems().indexOf((Object)tabItem);
    }

    @Override
    public final void open(AbstractTabItemFactory tabItemFactory) {
        boolean inBackground = tabItemFactory.isInBackground();
        MainTabItem tab = this.tryFindTab(tabItemFactory);
        if (tab != null && !tabItemFactory.isForceReopen()) {
            this.maybeActivate(tab, inBackground);
        } else {
            String tabId = tabItemFactory.getId();
            assert (tabId.startsWith("openbis_")) : "Unspecified component id.";
            HelpPageIdentifier helpId = tabItemFactory.getHelpPageIdentifier();
            String linkOrNull = tabItemFactory.tryGetLink();
            assert (helpId != null) : "Unspecified help identifier";
            MainTabItem newTab = new MainTabItem(tabItemFactory.create(), tabId, helpId, linkOrNull);
            newTab.setHideMode(Style.HideMode.OFFSETS);
            if (tab != null) {
                int oldPosition = this.getTabPosition(tab);
                tab.close();
                this.insert(newTab, oldPosition);
            } else {
                this.add(newTab);
            }
            this.openTabs.put(tabId, newTab);
            this.maybeActivate(newTab, inBackground);
        }
    }

    private void maybeActivate(MainTabItem tab, boolean inBackground) {
        if (!inBackground) {
            this.setSelection(tab);
        }
    }

    @Override
    public final void reset() {
        for (TabItem tabItem : new ArrayList<MainTabItem>(this.openTabs.values())) {
            tabItem.close();
        }
    }

    protected void onItemContextMenu(TabItem item, int x, int y) {
        boolean shouldInitializeContextMenu = this.closeContextMenu == null;
        super.onItemContextMenu(item, x, y);
        if (shouldInitializeContextMenu) {
            this.bookmarkMenuItem = this.createBookmarkMenuItem();
            this.closeContextMenu.add((Component)this.bookmarkMenuItem);
            this.helpMenuItem = this.createHelpMenuItem();
            this.closeContextMenu.add((Component)this.helpMenuItem);
            super.onItemContextMenu(item, x, y);
        }
        boolean bookmarkNotAvailable = ((MainTabItem)item).getLinkOrNull() == null;
        this.bookmarkMenuItem.setEnabled(!bookmarkNotAvailable);
    }

    private MenuItem createHelpMenuItem() {
        return new MenuItem("Help", (SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                MainTabItem selectedTab = (MainTabItem)((Object)((Menu)ce.getContainer()).getData("tab"));
                URLMethodWithParameters url = new URLMethodWithParameters(GenericConstants.HELP_REDIRECT_SERVLET_NAME);
                HelpPageIdentifier helpPageId = selectedTab.getHelpPageIdentifier();
                url.addParameter("pageTitle", helpPageId.getHelpPageTitle(MainTabPanel.this.viewContext));
                url.addParameter("specific", Boolean.toString(helpPageId.isSpecific()));
                WindowUtils.openWindow(URL.encode((String)url.toString()));
            }
        });
    }

    private MenuItem createBookmarkMenuItem() {
        return new MenuItem(this.viewContext.getMessage("tab_link", new Object[0]), (SelectionListener)new SelectionListener<MenuEvent>(){

            public void componentSelected(MenuEvent ce) {
                MainTabItem selectedTab = (MainTabItem)((Object)((Menu)ce.getContainer()).getData("tab"));
                String linkToken = selectedTab.getLinkOrNull();
                if (!$assertionsDisabled && linkToken == null) {
                    throw new AssertionError();
                }
                String link = LinkRenderer.renderAsLinkWithAnchor(MainTabPanel.this.viewContext.getMessage("url", new Object[0]), "#" + linkToken, false);
                MessageBox.info((String)MainTabPanel.this.viewContext.getMessage("tab_link", new Object[0]), (String)MainTabPanel.this.viewContext.getMessage("tab_link_message", link), null);
            }
        });
    }

    @Override
    public Widget asWidget() {
        return this;
    }

    private final class MainTabItem
    extends TabItem {
        private final ITabItem tabItem;
        private final String idPrefix;
        private final String linkOrNull;
        private final HelpPageIdentifier helpPageIdentifier;

        public MainTabItem(ITabItem tabItem, String idPrefix, HelpPageIdentifier helpPageIdentifier, String linkOrNull) {
            this.tabItem = tabItem;
            this.idPrefix = idPrefix;
            this.helpPageIdentifier = helpPageIdentifier;
            this.linkOrNull = linkOrNull;
            this.setId(String.valueOf(idPrefix) + MainTabPanel.TAB_SUFFIX);
            this.setClosable(true);
            this.setLayout((Layout)new FitLayout());
            this.addStyleName("pad-text");
            this.add(tabItem.getComponent());
            tabItem.getComponent().addListener(AppEvents.CloseViewer, this.createCloseViewerListener());
            tabItem.getTabTitleUpdater().bind(this);
            this.addListener(Events.BeforeClose, this.createBeforeCloseListener());
            this.addListener(Events.Close, this.createCloseTabListener());
            this.addListener(Events.Select, this.createActivateTabListener());
        }

        public HelpPageIdentifier getHelpPageIdentifier() {
            return this.helpPageIdentifier;
        }

        public String getLinkOrNull() {
            return this.linkOrNull;
        }

        public void close() {
            super.close();
            this.cleanup();
        }

        private void cleanup() {
            this.tabItem.onClose();
            MainTabPanel.this.openTabs.remove(this.idPrefix);
            if (MainTabPanel.this.openTabs.size() == 0) {
                MainTabPanel.this.syncSize();
            }
        }

        private Listener<ComponentEvent> createCloseViewerListener() {
            return new Listener<ComponentEvent>(){

                public final void handleEvent(ComponentEvent be) {
                    if (be.getType() == AppEvents.CloseViewer) {
                        MainTabItem.this.close();
                    }
                }
            };
        }

        private Listener<TabPanelEvent> createCloseTabListener() {
            return new Listener<TabPanelEvent>(){

                public final void handleEvent(TabPanelEvent be) {
                    if (be.getType().equals(Events.Close)) {
                        MainTabItem.this.cleanup();
                    }
                }
            };
        }

        private Listener<TabPanelEvent> createActivateTabListener() {
            return new Listener<TabPanelEvent>(){

                public final void handleEvent(TabPanelEvent be) {
                    if (be.getType().equals(Events.Select)) {
                        MainTabItem.this.tabItem.onActivate(MainTabItem.this.linkOrNull);
                    }
                }
            };
        }

        private Listener<TabPanelEvent> createBeforeCloseListener() {
            return new Listener<TabPanelEvent>(){
                private boolean closeConfirmed = false;

                public void handleEvent(TabPanelEvent be) {
                    if (MainTabItem.this.tabItem.isCloseConfirmationNeeded() && !this.closeConfirmed) {
                        be.setCancelled(true);
                        new ConfirmationDialog(MainTabPanel.this.viewContext.getMessage("confirm_title", new Object[0]), MainTabPanel.this.viewContext.getMessage("confirm_close_msg", new Object[0])){

                            @Override
                            protected void onYes() {
                                closeConfirmed = true;
                                MainTabItem.this.close();
                            }
                        }.show();
                    }
                }
            };
        }
    }
}

