/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.modules;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TopMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModuleInitializationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.webapp.WebAppSortingAndCodeComparator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebApp;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.WebAppContext;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModulesMenu
extends TopMenuItem
implements IModuleInitializationObserver {
    private IViewContext<?> viewContext;
    private ComponentProvider componentProvider;

    public ModulesMenu(IViewContext<?> viewContext, IClientPluginFactoryProvider clientPluginFactoryProvider, ComponentProvider componentProvider) {
        super(viewContext.getMessage("menu_modules", new Object[0]));
        this.viewContext = viewContext;
        this.componentProvider = componentProvider;
        this.setId("openbis_top-menu_MODULES");
        Menu submenu = new Menu();
        this.setMenu(submenu);
        this.hide();
        clientPluginFactoryProvider.registerModuleInitializationObserver(this);
    }

    void addModuleItems(List<IModule> modules) {
        Menu submenu = this.getMenu();
        for (IModule module : modules) {
            for (MenuItem menuItem : module.getMenuItems()) {
                submenu.add((Component)menuItem);
            }
        }
    }

    void addWebAppsItems() {
        ArrayList<WebApp> webApps = new ArrayList<WebApp>();
        for (WebApp webApp : this.getViewContext().getModel().getApplicationInfo().getWebapps()) {
            if (!webApp.matchesContext(WebAppContext.MODULES_MENU)) continue;
            webApps.add(webApp);
        }
        Collections.sort(webApps, new WebAppSortingAndCodeComparator());
        Menu submenu = this.getMenu();
        for (final WebApp webApp : webApps) {
            IActionMenuItem actionMenuItem = new IActionMenuItem(){

                @Override
                public String getMenuText(IMessageProvider messageProvider) {
                    return webApp.getLabel();
                }

                @Override
                public String getMenuId() {
                    return "openbis_top-menu_" + webApp.getCode();
                }
            };
            submenu.add((Component)new ActionMenu(actionMenuItem, this.viewContext, this.componentProvider.createWebApp(webApp)));
        }
    }

    private static void simplifyIfNecessary(TopMenuItem topMenu) {
        MenuItem menuItem;
        if (topMenu.getMenu().getItemCount() == 1 && (menuItem = (MenuItem)topMenu.getMenu().getItem(0)).getSubMenu() != null) {
            topMenu.setText(menuItem.getText());
            topMenu.setMenu(menuItem.getSubMenu());
        }
    }

    @Override
    public void notify(List<IModule> successfullyInitializedModules) {
        this.addModuleItems(successfullyInitializedModules);
        this.addWebAppsItems();
        ModulesMenu.simplifyIfNecessary(this);
        if (this.getMenu().getItemCount() > 0) {
            this.show();
        }
    }

    private IViewContext<?> getViewContext() {
        return this.viewContext;
    }
}

