/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IMainPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.ActionMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.IActionMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TopMenu;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.TopMenuItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.AboutBoxAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.ChangeUserSettingsAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.LoginAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.LogoutAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.SessionContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.User;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Menu;

public final class LoggedUserMenu
extends TopMenuItem {
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public LoggedUserMenu(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        super(null);
        this.setId("user_menu");
        this.viewContext = viewContext;
        Menu submenu = new Menu();
        submenu.add((Component)new ActionMenu((IActionMenuItem)TopMenu.ActionMenuKind.USER_MENU_ABOUT_BOX, viewContext, (IDelegatedAction)new AboutBoxAction(viewContext)));
        if (viewContext.getModel().isAnonymousLogin()) {
            submenu.add((Component)new ActionMenu((IActionMenuItem)TopMenu.ActionMenuKind.USER_MENU_LOGIN, viewContext, (IDelegatedAction)new LoginAction(viewContext)));
        } else {
            submenu.add((Component)new ActionMenu((IActionMenuItem)TopMenu.ActionMenuKind.USER_MENU_CHANGE_SETTINGS, viewContext, (IDelegatedAction)new ChangeUserSettingsAction(viewContext, this, this.createOnDisplaySettingsResetAction(componentProvider))));
            submenu.add((Component)new ActionMenu((IActionMenuItem)TopMenu.ActionMenuKind.USER_MENU_LOGOUT, viewContext, (IDelegatedAction)new LogoutAction(viewContext)));
        }
        this.setMenu(submenu);
        this.refreshTitle();
    }

    public void refreshTitle() {
        this.setText(this.getUserInfo());
    }

    private final String getUserInfo() {
        SessionContext sessionContext = this.viewContext.getModel().getSessionContext();
        User user = sessionContext.getUser();
        String userName = user.getUserName();
        String homeGroup = user.getHomeGroupCode();
        String info = homeGroup == null ? this.viewContext.getMessage("header_userWithoutHomegroup", userName) : this.viewContext.getMessage("header_userWithHomegroup", userName, homeGroup);
        return info;
    }

    public IDelegatedAction createOnDisplaySettingsResetAction(final ComponentProvider componentProvider) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                IMainPanel tabPanelOrNull = componentProvider.tryGetMainTabPanel();
                if (tabPanelOrNull != null) {
                    tabPanelOrNull.reset();
                }
            }
        };
    }
}

