/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.TooltipRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ExperimentTypeModel
extends SimplifiedBaseModelData {
    private static final long serialVersionUID = 1L;

    public ExperimentTypeModel(ExperimentType experimentType) {
        this.set("code", experimentType.getCode());
        this.set("object", experimentType);
        this.set("tooltip", TooltipRenderer.renderAsTooltip(experimentType.getCode(), experimentType.getDescription()));
    }

    public static final List<ExperimentTypeModel> convert(List<ExperimentType> experimentTypes, boolean withAll) {
        ArrayList<ExperimentTypeModel> result = new ArrayList<ExperimentTypeModel>();
        for (ExperimentType st : experimentTypes) {
            result.add(new ExperimentTypeModel(st));
        }
        if (withAll && experimentTypes.size() > 0) {
            result.add(0, ExperimentTypeModel.createAllTypesModel(experimentTypes));
        }
        return result;
    }

    private static ExperimentTypeModel createAllTypesModel(List<ExperimentType> basicTypes) {
        ExperimentType allExperimentType = new ExperimentType();
        allExperimentType.setCode("(all)");
        HashSet<ExperimentTypePropertyType> allPropertyTypes = new HashSet<ExperimentTypePropertyType>();
        for (ExperimentType basicType : basicTypes) {
            allPropertyTypes.addAll(basicType.getAssignedPropertyTypes());
        }
        allExperimentType.setExperimentTypePropertyTypes(new ArrayList<ExperimentTypePropertyType>(allPropertyTypes));
        return new ExperimentTypeModel(allExperimentType);
    }
}

