/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.model;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.TooltipRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.ArrayList;
import java.util.List;

public class SampleTypeModel
extends SimplifiedBaseModelData {
    private static final long serialVersionUID = 1L;

    public SampleTypeModel(SampleType sampleType) {
        this.set("code", sampleType.getCode());
        this.set("object", sampleType);
        this.set("tooltip", TooltipRenderer.renderAsTooltip(sampleType.getCode(), sampleType.getDescription()));
    }

    public static final List<SampleTypeModel> convert(List<SampleType> sampleTypes, boolean onlyListable, boolean withAll, boolean withTypeInFile) {
        ArrayList<SampleTypeModel> result = new ArrayList<SampleTypeModel>();
        List<SampleType> filteredTypes = SampleTypeModel.filter(sampleTypes, onlyListable);
        for (SampleType sampleType : filteredTypes) {
            result.add(new SampleTypeModel(sampleType));
        }
        if (withAll && filteredTypes.size() > 0) {
            result.add(0, SampleTypeModel.createAllTypesModel(filteredTypes));
        }
        if (withTypeInFile && filteredTypes.size() > 0) {
            result.add(0, SampleTypeModel.createTypeInFileModel());
        }
        return result;
    }

    private static List<SampleType> filter(List<SampleType> sampleTypes, boolean onlyListable) {
        ArrayList<SampleType> result = new ArrayList<SampleType>();
        for (SampleType sampleType : sampleTypes) {
            if (onlyListable && !sampleType.isListable()) continue;
            result.add(sampleType);
        }
        return result;
    }

    private static SampleTypeModel createAllTypesModel(List<SampleType> basicTypes) {
        SampleType allSampleType = SampleType.createAllSampleType(basicTypes, true);
        return new SampleTypeModel(allSampleType);
    }

    private static SampleTypeModel createTypeInFileModel() {
        SampleType typeInFile = new SampleType();
        typeInFile.setCode("(multiple)");
        typeInFile.setListable(false);
        return new SampleTypeModel(typeInFile);
    }
}

