/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactoryUsingWildcards;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModule;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IModuleInitializationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.ModuleInitializationController;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.WildcardSupportingPluginFactoryMap;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKindAndTypeCode;
import ch.systemsx.cisd.openbis.plugin.generic.client.web.client.application.ClientPluginFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultClientPluginFactoryProvider
implements IClientPluginFactoryProvider {
    private final Set<IClientPluginFactory> pluginFactories = new HashSet<IClientPluginFactory>();
    private final WildcardSupportingPluginFactoryMap pluginFactoryMap = new WildcardSupportingPluginFactoryMap();
    private final IClientPluginFactory genericPluginFactory;

    public DefaultClientPluginFactoryProvider(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        this.genericPluginFactory = new ClientPluginFactory(originalViewContext);
        this.registerPluginFactories(originalViewContext);
    }

    private final void registerPluginFactories(IViewContext<ICommonClientServiceAsync> originalViewContext) {
        this.registerPluginFactory(new ch.systemsx.cisd.openbis.plugin.demo.client.web.client.application.ClientPluginFactory(originalViewContext));
        this.registerPluginFactory(new ch.systemsx.cisd.openbis.plugin.query.client.web.client.application.ClientPluginFactory(originalViewContext));
    }

    protected final void registerPluginFactory(IClientPluginFactory pluginFactory) {
        assert (pluginFactory != null) : "Unspecified client plugin factory.";
        this.pluginFactories.add(pluginFactory);
        EntityKind[] entityKindArray = EntityKind.values();
        int n = entityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            for (String entityType : pluginFactory.getEntityTypeCodes(entityKind)) {
                EntityKindAndTypeCode key = new EntityKindAndTypeCode(entityKind, entityType);
                IClientPluginFactory previousValue = this.pluginFactoryMap.tryPluginFactory(key);
                if (previousValue != null) {
                    throw new IllegalArgumentException("There is already a client plugin factory '" + previousValue.getClass().getName() + "' registered for key '" + key + "'.");
                }
                this.pluginFactoryMap.addMapping(key, pluginFactory);
            }
            ++n2;
        }
    }

    protected final void registerPluginFactory(IClientPluginFactoryUsingWildcards pluginFactory) {
        assert (pluginFactory != null) : "Unspecified client plugin factory.";
        this.pluginFactories.add(pluginFactory);
        EntityKind[] entityKindArray = EntityKind.values();
        int n = entityKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityKind entityKind = entityKindArray[n2];
            for (String entityType : pluginFactory.getOrderedEntityTypeCodes(entityKind)) {
                EntityKindAndTypeCode key = new EntityKindAndTypeCode(entityKind, entityType);
                this.pluginFactoryMap.addMapping(key, pluginFactory);
            }
            ++n2;
        }
    }

    @Override
    public final IClientPluginFactory getClientPluginFactory(EntityKind entityKind, BasicEntityType entityType) {
        assert (entityKind != null) : "Unspecified entity kind.";
        assert (entityType != null) : "Unspecified entity type.";
        IClientPluginFactory pluginFactory = this.pluginFactoryMap.tryPluginFactory(new EntityKindAndTypeCode(entityKind, entityType));
        if (pluginFactory != null && pluginFactory.isEnabled()) {
            return pluginFactory;
        }
        return this.genericPluginFactory;
    }

    private final List<IModule> getUninitializedModules() {
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (IClientPluginFactory factory : this.pluginFactories) {
            IModule m;
            if (!factory.isEnabled() || (m = factory.tryGetModule()) == null) continue;
            modules.add(m);
        }
        return modules;
    }

    @Override
    public void registerModuleInitializationObserver(IModuleInitializationObserver observer) {
        ModuleInitializationController.createAndInitialize(this.getUninitializedModules()).addObserver(observer);
    }
}

