/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.CommonViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public class LinkRenderer {
    private static final String INVALID_STYLE_CLASS = "invalid";
    private static final String LINK_STYLE = "link-style";

    @Deprecated
    public static GridCellRenderer<BaseEntityModel<?>> createLinkRenderer() {
        return new GridCellRenderer<BaseEntityModel<?>>(){

            public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
                if (model.get(property) == null) {
                    return "";
                }
                String originalValue = model.get(property).toString();
                String tokenOrNull = model.tryGetLink(property);
                if (tokenOrNull == null && CommonViewContext.ClientStaticState.isSimpleMode()) {
                    return new MultilineHTML(originalValue).toString();
                }
                if (CommonViewContext.ClientStaticState.isSimpleMode()) {
                    String href = "#" + tokenOrNull;
                    return LinkRenderer.renderAsLinkWithAnchor(originalValue, href, false);
                }
                return LinkRenderer.renderAsLinkWithAnchor(originalValue);
            }
        };
    }

    public static GridCellRenderer<BaseEntityModel<?>> createLinkRenderer(final boolean renderOriginalValueForEmptyToken, final int columnIndex) {
        return new GridCellRenderer<BaseEntityModel<?>>(){

            public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
                ISerializableComparable cell;
                List<ISerializableComparable> values;
                if (model.get(property) == null) {
                    return "";
                }
                boolean invalidate = false;
                if (model.getBaseObject() instanceof TableModelRowWithObject && columnIndex < (values = ((TableModelRowWithObject)model.getBaseObject()).getValues()).size() && (cell = values.get(columnIndex)) instanceof EntityTableCell) {
                    invalidate = ((EntityTableCell)cell).isInvalid();
                }
                String originalValue = model.get(property).toString();
                String tokenOrNull = model.tryGetLink(property);
                if (tokenOrNull == null && (renderOriginalValueForEmptyToken || CommonViewContext.ClientStaticState.isSimpleMode())) {
                    return new MultilineHTML(originalValue).toString();
                }
                if (CommonViewContext.ClientStaticState.isSimpleMode()) {
                    String href = "#" + tokenOrNull;
                    return LinkRenderer.renderAsLinkWithAnchor(originalValue, href, false, invalidate);
                }
                return LinkRenderer.renderAsLinkWithAnchor(originalValue, invalidate);
            }
        };
    }

    public static GridCellRenderer<BaseEntityModel<?>> createExternalLinkRenderer(final String overridenLinkTextOrNull) {
        return new GridCellRenderer<BaseEntityModel<?>>(){

            public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
                String originalValue = StringEscapeUtils.unescapeHtml(StringUtils.toStringEmptyIfNull(model.get(property)));
                String linkText = overridenLinkTextOrNull != null ? overridenLinkTextOrNull : originalValue;
                return LinkRenderer.renderAsLinkWithAnchor(linkText, originalValue, true);
            }
        };
    }

    public static GridCellRenderer<BaseEntityModel<?>> createExternalLinkRenderer() {
        return LinkRenderer.createExternalLinkRenderer(null);
    }

    public static String renderAsLink(String message) {
        Element div = DOM.createDiv();
        div.setInnerHTML(message);
        div.setClassName(LINK_STYLE);
        return DOM.toString((Element)div);
    }

    public static String renderAsLinkWithAnchor(String text) {
        return LinkRenderer.renderAsLinkWithAnchor(text, "#", false, false);
    }

    public static String renderAsLinkWithAnchor(String text, boolean invalidate) {
        return LinkRenderer.renderAsLinkWithAnchor(text, "#", false, invalidate);
    }

    public static String renderAsLinkWithAnchor(String text, String href, boolean openInNewWindow) {
        return LinkRenderer.renderAsLinkWithAnchor(text, href, openInNewWindow, false);
    }

    public static String renderAsLinkWithAnchor(String text, String href, boolean openInNewWindow, boolean invalidate) {
        Element anchor = DOM.createAnchor();
        DOM.setInnerHTML((Element)anchor, (String)text);
        DOM.setElementProperty((Element)anchor, (String)"href", (String)href);
        if (openInNewWindow) {
            DOM.setElementProperty((Element)anchor, (String)"target", (String)"blank");
        }
        if (invalidate) {
            anchor.addClassName(INVALID_STYLE_CLASS);
        }
        return DOM.toString((Element)anchor);
    }

    public static Widget getLinkWidget(String text, ClickHandler listener) {
        return LinkRenderer.getLinkWidget(text, listener, null);
    }

    public static Widget getLinkWidget(String text, ClickHandler listener, String historyHref) {
        return LinkRenderer.getLinkAnchor(text, listener, historyHref);
    }

    public static Anchor getLinkAnchor(String text, ClickHandler listener, String historyHref) {
        return LinkRenderer.getLinkAnchor(text, listener, historyHref, false);
    }

    public static Widget getLinkWidget(String text, ClickHandler listener, String historyHref, boolean invalidate) {
        return LinkRenderer.getLinkAnchor(text, listener, historyHref, invalidate);
    }

    private static Anchor getLinkAnchor(String text, ClickHandler listener, String historyHref, boolean invalidate) {
        Anchor link = new Anchor();
        link.setHTML(text);
        link.setStyleName(LINK_STYLE);
        LinkRenderer.setHrefOrListener(listener, historyHref, link);
        if (invalidate) {
            LinkRenderer.invalidate((Widget)link);
        }
        return link;
    }

    public static void invalidate(Widget linkWidget) {
        linkWidget.addStyleName(INVALID_STYLE_CLASS);
    }

    private static void setHrefOrListener(ClickHandler listener, String historyHref, Anchor link) {
        if (historyHref != null && CommonViewContext.ClientStaticState.isSimpleMode()) {
            link.setHref("#" + historyHref);
        } else if (listener != null) {
            link.addClickHandler(listener);
        }
    }

    public static Widget createButtonLink(Button button, final IDelegatedAction normalViewModeAction, final IURLProvider simpleViewModeUrlProvider) {
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (CommonViewContext.ClientStaticState.isSimpleMode()) {
                    String url = simpleViewModeUrlProvider.tryGetURL();
                    if (url != null) {
                        History.newItem((String)url);
                    }
                } else {
                    normalViewModeAction.execute();
                }
            }
        });
        return button;
    }

    public static interface IURLProvider {
        public String tryGetURL();
    }
}

