/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.CommonViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.LinkRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.MultilineHTML;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import java.util.List;

public class MaterialRenderer
implements GridCellRenderer<BaseEntityModel<?>> {
    private int columnIndex;

    public MaterialRenderer(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
        if (model.get(property) == null) {
            return "";
        }
        String originalValue = model.get(property).toString();
        String tokenOrNull = model.tryGetLink(property);
        List<ISerializableComparable> values = ((TableModelRowWithObject)model.getBaseObject()).getValues();
        if (this.columnIndex < values.size()) {
            EntityTableCell newEntityCell = new EntityTableCell(EntityKind.MATERIAL, originalValue, originalValue);
            values.set(this.columnIndex, newEntityCell);
        }
        if (tokenOrNull == null && CommonViewContext.ClientStaticState.isSimpleMode()) {
            return new MultilineHTML(originalValue).toString();
        }
        if (CommonViewContext.ClientStaticState.isSimpleMode()) {
            String href = "#" + tokenOrNull;
            return LinkRenderer.renderAsLinkWithAnchor(originalValue, href, false);
        }
        return LinkRenderer.renderAsLinkWithAnchor(originalValue);
    }
}

