/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.VocabularyPropertyColRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermTableCell;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import java.util.List;

public class VocabularyTermStringCellRenderer
implements GridCellRenderer<BaseEntityModel<?>> {
    private final int columnIndex;

    public VocabularyTermStringCellRenderer(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public Object render(BaseEntityModel<?> model, String property, ColumnData config, int rowIndex, int colIndex, ListStore<BaseEntityModel<?>> store, Grid<BaseEntityModel<?>> grid) {
        String originalValue;
        Object obj = model.get(property);
        String string = originalValue = obj == null ? null : obj.toString();
        if (StringUtils.isBlank(originalValue)) {
            return originalValue;
        }
        List<ISerializableComparable> values = ((TableModelRowWithObject)model.getBaseObject()).getValues();
        if (this.columnIndex >= values.size()) {
            return "";
        }
        ISerializableComparable cell = null;
        if (obj instanceof VocabularyTerm) {
            cell = new VocabularyTermTableCell((VocabularyTerm)obj);
            values.set(this.columnIndex, cell);
        }
        if (!((cell = values.get(this.columnIndex)) instanceof VocabularyTermTableCell)) {
            return cell.toString();
        }
        VocabularyTermTableCell vocabularyTermTableCell = (VocabularyTermTableCell)cell;
        VocabularyTerm vocabularyTerm = vocabularyTermTableCell.getVocabularyTerm();
        return VocabularyPropertyColRenderer.renderTerm(vocabularyTerm);
    }
}

