/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDisplaySettingsGetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDataModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnSettingsDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.CustomColumnsMetadataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.filter.FilterToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridCustomColumnInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SortInfo;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ColumnSettingsConfigurer<T extends Serializable> {
    public static final int DEFAULT_COLUMN_WIDTH = 150;
    private final TypedTableGrid<T> browserGrid;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final FilterToolbar<TableModelRowWithObject<T>> filterToolbar;
    private final CustomColumnsMetadataProvider customColumnsMetadataProvider;
    private final String resultSetKeyOrNull;
    private final ResultSetFetchConfig<String> pendingFetchConfigOrNull;

    public ColumnSettingsConfigurer(TypedTableGrid<T> browserGrid, IViewContext<ICommonClientServiceAsync> viewContext, FilterToolbar<TableModelRowWithObject<T>> filterToolbar, CustomColumnsMetadataProvider customColumnsMetadataProvider, String resultSetKeyOrNull, ResultSetFetchConfig<String> pendingFetchConfigOrNull) {
        this.browserGrid = browserGrid;
        this.viewContext = viewContext;
        this.filterToolbar = filterToolbar;
        this.customColumnsMetadataProvider = customColumnsMetadataProvider;
        this.resultSetKeyOrNull = resultSetKeyOrNull;
        this.pendingFetchConfigOrNull = pendingFetchConfigOrNull;
    }

    public void showDialog() {
        List<ColumnDataModel> settingsModel = TypedTableGrid.createColumnsSettingsModel(this.browserGrid.getFullColumnModel(), this.filterToolbar.extractFilteredColumnIds());
        AbstractColumnSettingsDataModelProvider provider = new AbstractColumnSettingsDataModelProvider(settingsModel){

            @Override
            public void onClose(List<ColumnDataModel> newColumnDataModels) {
                final ColumnModel newColumnModel = ColumnSettingsConfigurer.this.createNewColumnModel(newColumnDataModels);
                final List filteredColumnIds = ColumnSettingsConfigurer.getFilteredColumnIds(newColumnDataModels);
                String gridDisplayTypeID = ColumnSettingsConfigurer.this.browserGrid.getGridDisplayTypeID();
                DisplaySettingsManager displaySettingsManager = ColumnSettingsConfigurer.this.viewContext.getDisplaySettingsManager();
                displaySettingsManager.storeSettings(gridDisplayTypeID, new IDisplaySettingsGetter(){

                    @Override
                    public Object getModifier() {
                        return ColumnSettingsConfigurer.this.browserGrid;
                    }

                    @Override
                    public List<String> getFilteredColumnIds() {
                        return filteredColumnIds;
                    }

                    @Override
                    public ColumnModel getColumnModel() {
                        return newColumnModel;
                    }

                    @Override
                    public SortInfo getSortState() {
                        return ColumnSettingsConfigurer.this.browserGrid.getGridSortInfo();
                    }
                }, false);
                List<GridCustomColumnInfo> newCustomColumns = this.tryGetCustomColumnsInfo();
                if (newCustomColumns != null) {
                    ColumnSettingsConfigurer.this.customColumnsMetadataProvider.setCustomColumnsMetadata(newCustomColumns);
                }
                boolean customColumnsChanged = ColumnSettingsConfigurer.this.customColumnsMetadataProvider.getHasChangedAndSetFalse();
                ColumnSettingsConfigurer.this.browserGrid.recreateColumnModelAndRefreshColumnsWithFilters();
                boolean columnFiltersChanged = ColumnSettingsConfigurer.this.browserGrid.rebuildFiltersFromIds(filteredColumnIds);
                if (customColumnsChanged || columnFiltersChanged) {
                    ColumnSettingsConfigurer.this.browserGrid.debug("refreshing custom columns and/or filter distinct value in " + ColumnSettingsConfigurer.this.pendingFetchConfigOrNull + " mode");
                    ColumnSettingsConfigurer.this.browserGrid.reloadData(this.createRefreshSettingsFetchConfig());
                }
                ColumnSettingsConfigurer.this.browserGrid.refreshColumnsSettings();
                ColumnSettingsConfigurer.this.filterToolbar.refresh();
            }

            private ResultSetFetchConfig<String> createRefreshSettingsFetchConfig() {
                if (ColumnSettingsConfigurer.this.pendingFetchConfigOrNull == null) {
                    if (ColumnSettingsConfigurer.this.resultSetKeyOrNull == null) {
                        return ResultSetFetchConfig.createComputeAndCache();
                    }
                    return ResultSetFetchConfig.createFetchFromCacheAndRecompute(ColumnSettingsConfigurer.this.resultSetKeyOrNull);
                }
                return ColumnSettingsConfigurer.this.pendingFetchConfigOrNull;
            }
        };
        ColumnSettingsDialog.show(this.viewContext, provider, this.browserGrid.getGridDisplayTypeID());
    }

    private ColumnModel createNewColumnModel(List<ColumnDataModel> newColumnDataModels) {
        List<ColumnConfig> oldColumnsList = this.getOldColumnsList();
        Map<String, ColumnConfig> oldColumnsMap = this.getOldColumnsMap();
        LinkedList<ColumnConfig> columnsList = new LinkedList<ColumnConfig>();
        HashMap<String, ColumnConfig> columnsMap = new HashMap<String, ColumnConfig>();
        for (ColumnDataModel columnDataModel : newColumnDataModels) {
            String columnID = columnDataModel.getColumnID();
            ColumnConfig column = oldColumnsMap.get(columnID);
            if (column == null) {
                String header = columnDataModel.getHeader();
                column = new ColumnConfig(columnID, header, 150);
            }
            column.setHidden(!columnDataModel.isVisible());
            columnsList.add(column);
            columnsMap.put(column.getId(), column);
        }
        int index = 0;
        for (ColumnConfig oldColumn : oldColumnsList) {
            if (!columnsMap.containsKey(oldColumn.getId())) {
                columnsList.add(index, oldColumn);
            }
            ++index;
        }
        return new ColumnModel(columnsList);
    }

    private List<ColumnConfig> getOldColumnsList() {
        return this.browserGrid.getFullColumnModel().getColumns();
    }

    private Map<String, ColumnConfig> getOldColumnsMap() {
        List<ColumnConfig> columns = this.getOldColumnsList();
        HashMap<String, ColumnConfig> map = new HashMap<String, ColumnConfig>();
        for (ColumnConfig columnConfig : columns) {
            map.put(columnConfig.getId(), columnConfig);
        }
        return map;
    }

    private static List<String> getFilteredColumnIds(List<ColumnDataModel> result) {
        ArrayList<String> filteredColumnsIds = new ArrayList<String>();
        for (ColumnDataModel model : result) {
            if (!model.hasFilter() || filteredColumnsIds.size() >= 24) continue;
            filteredColumnsIds.add(model.getColumnID());
        }
        return filteredColumnsIds;
    }
}

