/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.renderer.TooltipRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CustomImport;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import java.util.ArrayList;
import java.util.List;

public class CustomImportTypeSelectionWidget
extends DropDownList<CustomImportModelData, CustomImport> {
    public static final String SUFFIX = "custom-import";
    private IViewContext<?> viewContext;

    public CustomImportTypeSelectionWidget(IViewContext<?> viewContext, String idSuffix, String initialCodeOrNullParameter) {
        super(viewContext, SUFFIX + idSuffix, "custom_import", "name", "custom import", "custom import types");
        this.viewContext = viewContext;
        this.setAutoSelectFirst(false);
        this.setTemplate(GWTUtils.getTooltipTemplate("name", "tooltip"));
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[0];
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<CustomImport>> callback) {
        this.viewContext.getCommonService().getCustomImports(callback);
        callback.ignore();
    }

    @Override
    protected List<CustomImportModelData> convertItems(List<CustomImport> items) {
        ArrayList<CustomImportModelData> results = new ArrayList<CustomImportModelData>();
        for (CustomImport sp : items) {
            results.add(new CustomImportModelData(sp));
        }
        return results;
    }

    public CustomImport tryGetSelectedCustomImport() {
        return (CustomImport)super.tryGetSelected();
    }

    public static class CustomImportModelData
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;

        public CustomImportModelData(CustomImport customImport) {
            String customImportKey = customImport.getCode();
            String customImportName = CustomImportModelData.getProperty(customImport, CustomImport.PropertyNames.NAME.getName(), customImportKey);
            this.set("code", customImportKey);
            this.set("name", customImportName);
            this.set("object", customImport);
            this.set("tooltip", TooltipRenderer.renderAsTooltip(customImportName, CustomImportModelData.getProperty(customImport, CustomImport.PropertyNames.DESCRIPTION.getName(), null)));
        }

        private static String getProperty(CustomImport customImport, String propName, String defVal) {
            String value = customImport.getProperties().get(propName);
            return value == null ? (defVal == null ? null : defVal) : value;
        }
    }
}

