/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BasicLoginCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.EnterKeyListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.TextField;

public class LoginWidget
extends VerticalPanel {
    private static final String PREFIX = "login_";
    private static final String ID_PREFIX = "openbis_login_";
    static final String USER_FIELD_ID = "openbis_login_user";
    static final String PASSWORD_FIELD_ID = "openbis_login_password";
    static final String BUTTON_ID = "openbis_login_button";
    private final TextField<String> userField;
    private final TextField<String> passwordField;
    private final Button button;
    private final FormPanel formPanel;

    public LoginWidget(IViewContext<ICommonClientServiceAsync> viewContext) {
        this.setSpacing(10);
        this.setBorders(false);
        this.add((Component)new Text(viewContext.getMessage("login_invitation", new Object[0])));
        this.formPanel = LoginWidget.createFormPanel();
        this.userField = this.createUserField(viewContext);
        this.formPanel.add(this.userField);
        this.passwordField = this.createPasswordField(viewContext);
        this.formPanel.add(this.passwordField);
        this.button = this.createButton(viewContext);
        this.formPanel.addButton(this.button);
        this.focusOnFirstField();
        this.add((Component)this.formPanel);
    }

    private void focusOnFirstField() {
        this.formPanel.getItem(0).focus();
    }

    private static final FormPanel createFormPanel() {
        FormPanel formPanel = new FormPanel();
        formPanel.setBodyBorder(false);
        formPanel.setBorders(false);
        formPanel.setHeaderVisible(false);
        formPanel.setFieldWidth(130);
        formPanel.setWidth(250);
        formPanel.setButtonAlign(Style.HorizontalAlignment.RIGHT);
        return formPanel;
    }

    private final TextField<String> createUserField(IViewContext<ICommonClientServiceAsync> viewContext) {
        TextField field = new TextField();
        field.setFieldLabel(viewContext.getMessage("login_userLabel", new Object[0]));
        field.setId(USER_FIELD_ID);
        field.setAllowBlank(false);
        field.setValidateOnBlur(true);
        this.addEnterKeyListener((Field<String>)field, viewContext);
        return field;
    }

    private final void addEnterKeyListener(Field<String> field, final IViewContext<ICommonClientServiceAsync> viewContext) {
        field.addKeyListener((KeyListener)new EnterKeyListener(){

            @Override
            protected final void onEnterKey() {
                LoginWidget.this.doLogin(viewContext);
            }
        });
    }

    private final TextField<String> createPasswordField(IViewContext<ICommonClientServiceAsync> viewContext) {
        TextField field = new TextField();
        field.setPassword(true);
        field.setFieldLabel(viewContext.getMessage("login_passwordLabel", new Object[0]));
        field.setId(PASSWORD_FIELD_ID);
        field.setAllowBlank(false);
        field.setValidateOnBlur(true);
        this.addEnterKeyListener((Field<String>)field, viewContext);
        return field;
    }

    private final Button createButton(final IViewContext<ICommonClientServiceAsync> viewContext) {
        Button b = new Button(viewContext.getMessage("login_buttonLabel", new Object[0]));
        b.setId(BUTTON_ID);
        b.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                LoginWidget.this.doLogin(viewContext);
            }
        });
        return b;
    }

    private final void doLogin(IViewContext<ICommonClientServiceAsync> viewContext) {
        if (GWTUtils.isTesting() || this.formPanel.isValid()) {
            this.button.disable();
            String user = (String)this.userField.getValue();
            String password = (String)this.passwordField.getValue();
            viewContext.getService().tryToLogin(user, password, new LoginCallback(viewContext));
        }
    }

    public final void resetFields() {
        this.userField.reset();
        this.passwordField.reset();
        this.button.enable();
    }

    protected final void onLoad() {
        super.onLoad();
        this.resetFields();
    }

    public final class LoginCallback
    extends BasicLoginCallback {
        private LoginCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext, "login_failed");
        }

        @Override
        public final void finishOnFailure(Throwable caught) {
            LoginWidget.this.resetFields();
        }
    }
}

