/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AuthorizationGroup;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import java.util.ArrayList;
import java.util.List;

public final class PersonListDeletionConfirmationDialog
extends AbstractDataConfirmationDialog<List<Person>> {
    private static final int LABEL_WIDTH = 60;
    private static final int FIELD_WIDTH = 180;
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final AbstractAsyncCallback<Void> callback;
    private final AuthorizationGroup authorizationGroup;

    public PersonListDeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<Person> persons, AuthorizationGroup authorizationGroup, AbstractAsyncCallback<Void> callback) {
        super(viewContext, persons, viewContext.getMessage("remove_persons_from_authorization_group_confirmation_title", new Object[0]));
        assert (authorizationGroup != null);
        this.viewContext = viewContext;
        this.authorizationGroup = authorizationGroup;
        this.callback = callback;
    }

    @Override
    protected void executeConfirmedAction() {
        this.viewContext.getCommonService().removePersonsFromAuthorizationGroup(TechId.create(this.authorizationGroup), this.extractCodes((List)this.data), this.callback);
    }

    private List<String> extractCodes(List<Person> persons) {
        ArrayList<String> result = new ArrayList<String>();
        for (Person p : persons) {
            result.add(p.getUserId());
        }
        return result;
    }

    @Override
    protected String createMessage() {
        List<String> codes = this.extractCodes((List)this.data);
        return this.viewContext.getMessage("remove_persons_from_authorization_group_confirmation_message", codes.size(), StringUtils.abbreviate(StringUtils.joinList(codes), 1000), this.authorizationGroup.getCode());
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(60);
        this.formPanel.setFieldWidth(180);
    }
}

