/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.DragEvent;
import com.extjs.gxt.ui.client.event.DragListener;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.fx.Draggable;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Container;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.SplitBar;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class RowLayoutManager {
    private static final IManipulator HEIGHT_MANIPULATOR = new IManipulator(){

        @Override
        public void setFor(RowData rowData, double newValue) {
            rowData.setHeight(newValue);
        }

        @Override
        public double getFor(RowData rowData) {
            return rowData.getHeight();
        }

        @Override
        public int getFrameSizeFor(ContentPanel panel) {
            return panel.isRendered() ? panel.getFrameHeight() : 0;
        }

        @Override
        public int getSize(Container<?> container) {
            return container.getHeight();
        }

        @Override
        public int getPositionFrom(DragEvent dragEvent) {
            return dragEvent.getY();
        }
    };
    private static final IManipulator WIDTH_MANIPULATOR = new IManipulator(){

        @Override
        public void setFor(RowData rowData, double newValue) {
            rowData.setWidth(newValue);
        }

        @Override
        public double getFor(RowData rowData) {
            return rowData.getWidth();
        }

        @Override
        public int getFrameSizeFor(ContentPanel panel) {
            return panel.isRendered() ? panel.getFrameWidth() : 0;
        }

        @Override
        public int getSize(Container<?> container) {
            return container.getWidth();
        }

        @Override
        public int getPositionFrom(DragEvent dragEvent) {
            return dragEvent.getX();
        }
    };
    private final LayoutContainer container;
    private final IManipulator manipulator;
    private final List<DynamicRowData> dynamicRowDatas = new ArrayList<DynamicRowData>();
    private static final double DELTA = 0.02;

    public RowLayoutManager(LayoutContainer container, RowLayout rowLayout) {
        this.container = container;
        container.setLayout((Layout)rowLayout);
        Style.Orientation orientation = rowLayout.getOrientation();
        this.manipulator = orientation.equals((Object)Style.Orientation.VERTICAL) ? HEIGHT_MANIPULATOR : WIDTH_MANIPULATOR;
    }

    public void addToContainer(ContentPanel contentPanel, RowData rowData) {
        if (this.container.getItemCount() > 0) {
            Listener<BaseEvent> listener = this.createListener(contentPanel, this.dynamicRowDatas.size());
            contentPanel.addListener(Events.Render, listener);
        }
        contentPanel.setAnimCollapse(false);
        this.container.add((Widget)contentPanel, (LayoutData)rowData);
        double value = this.manipulator.getFor(rowData);
        if (value < 0.0 || value > 1.0) {
            return;
        }
        DynamicRowData dynamicRowData = new DynamicRowData();
        dynamicRowData.rowData = rowData;
        dynamicRowData.originalValue = value;
        dynamicRowData.panel = contentPanel;
        this.dynamicRowDatas.add(dynamicRowData);
        this.adjustRelative();
        Listener<BaseEvent> listener = new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent event) {
                RowLayoutManager.this.adjustRelative();
            }
        };
        contentPanel.addListener(Events.Collapse, (Listener)listener);
        contentPanel.addListener(Events.Expand, (Listener)listener);
    }

    private void adjustRelative() {
        double sum = 0.0;
        for (DynamicRowData data : this.dynamicRowDatas) {
            if (data.panel.isCollapsed()) continue;
            sum += data.originalValue;
        }
        for (DynamicRowData data : this.dynamicRowDatas) {
            double value = data.panel.isCollapsed() ? (double)this.manipulator.getFrameSizeFor(data.panel) : data.originalValue / sum;
            this.manipulator.setFor(data.rowData, value);
        }
        this.container.layout(true);
    }

    private Listener<BaseEvent> createListener(final ContentPanel contentPanel, final int indexInDynamicRowDataArray) {
        return new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                SplitBar splitBar = new SplitBar(Style.LayoutRegion.NORTH, (BoxComponent)contentPanel);
                Draggable draggable = splitBar.getDraggable();
                draggable.addDragListener(new DragListener(){
                    private int position;

                    public void dragEnd(DragEvent de) {
                        RowLayoutManager.this.handleSplitMovement(contentPanel, RowLayoutManager.this.manipulator.getPositionFrom(de) - this.position, indexInDynamicRowDataArray);
                    }

                    public void dragStart(DragEvent de) {
                        this.position = RowLayoutManager.this.manipulator.getPositionFrom(de);
                    }
                });
                draggable.setMoveAfterProxyDrag(false);
                splitBar.setAutoSize(false);
            }
        };
    }

    private void handleSplitMovement(ContentPanel contentPanel, int diff, int indexInDynamicRowDataArray) {
        int indexOfResizablePanelAbove = -1;
        int i = indexInDynamicRowDataArray - 1;
        while (i >= 0) {
            if (!this.dynamicRowDatas.get(i).panel.isCollapsed()) {
                indexOfResizablePanelAbove = i;
                break;
            }
            --i;
        }
        if (indexOfResizablePanelAbove < 0) {
            return;
        }
        int indexOfResizablePanelBelow = -1;
        int i2 = indexInDynamicRowDataArray;
        while (i2 < this.dynamicRowDatas.size()) {
            if (!this.dynamicRowDatas.get(i2).panel.isCollapsed()) {
                indexOfResizablePanelBelow = i2;
                break;
            }
            ++i2;
        }
        if (indexOfResizablePanelBelow < 0) {
            return;
        }
        int sum = 0;
        int i3 = 0;
        int n = this.container.getItemCount();
        while (i3 < n) {
            Component item = this.container.getItem(i3);
            if (item instanceof ContentPanel) {
                ContentPanel panel = (ContentPanel)item;
                sum += this.manipulator.getFrameSizeFor(panel);
            }
            ++i3;
        }
        int h = this.manipulator.getSize((Container<?>)this.container) - sum;
        DynamicRowData above = this.dynamicRowDatas.get(indexOfResizablePanelAbove);
        DynamicRowData below = this.dynamicRowDatas.get(indexOfResizablePanelBelow);
        double diffRatio = (double)diff / (double)h;
        diffRatio = Math.max(diffRatio, 0.02 - above.originalValue);
        diffRatio = Math.min(diffRatio, 0.98 - above.originalValue);
        diffRatio = Math.min(diffRatio, below.originalValue - 0.02);
        diffRatio = Math.max(diffRatio, below.originalValue - 1.0 + 0.02);
        DynamicRowData dynamicRowData = above;
        dynamicRowData.originalValue = dynamicRowData.originalValue + diffRatio;
        DynamicRowData dynamicRowData2 = below;
        dynamicRowData2.originalValue = dynamicRowData2.originalValue - diffRatio;
        this.adjustRelative();
    }

    private static final class DynamicRowData {
        private RowData rowData;
        private double originalValue;
        private ContentPanel panel;

        private DynamicRowData() {
        }
    }

    private static interface IManipulator {
        public double getFor(RowData var1);

        public void setFor(RowData var1, double var2);

        public int getFrameSizeFor(ContentPanel var1);

        public int getSize(Container<?> var1);

        public int getPositionFrom(DragEvent var1);
    }
}

