/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.SearchWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.LoginAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.menu.user.action.LogoutAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.History;

public class SimpleModeHeader
extends LayoutContainer {
    public static final String ID = "openbis_simple-mode-header";
    private final ToolBar toolBar;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public SimpleModeHeader(IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        this.viewContext = viewContext;
        this.setId(ID);
        this.setLayout((Layout)new FlowLayout());
        this.setBorders(true);
        this.toolBar = new ToolBar();
        this.add((Component)this.toolBar);
    }

    final void refresh() {
        this.toolBar.removeAll();
        this.toolBar.add(this.createHomeButton());
        this.toolBar.add((Component)new FillToolItem());
        this.toolBar.add((Component)new SearchWidget(this.viewContext));
        this.toolBar.add((Component)new SeparatorToolItem());
        this.toolBar.add((Component)(this.viewContext.getModel().isAnonymousLogin() ? this.createLoginButton() : this.createLogoutButton()));
    }

    private Component createHomeButton() {
        String homeLabel = this.viewContext.getMessage("home_buttonLabel", new Object[0]);
        return new Button(homeLabel, (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                URLMethodWithParameters url = new URLMethodWithParameters("");
                url.addParameter("action", "HOME");
                String urlParameters = url.toString().substring(1);
                History.newItem((String)urlParameters);
            }
        });
    }

    private Button createLoginButton() {
        String logoutLabel = this.viewContext.getMessage("login_buttonLabel", new Object[0]);
        return new Button(logoutLabel, (SelectionListener)new SelectionListener<ButtonEvent>(){
            private LoginAction loginAction;
            {
                this.loginAction = new LoginAction(SimpleModeHeader.this.viewContext);
            }

            public void componentSelected(ButtonEvent ce) {
                this.loginAction.execute();
            }
        });
    }

    private Button createLogoutButton() {
        String logoutLabel = this.viewContext.getMessage("logout_buttonLabel", new Object[0]);
        return new Button(logoutLabel, (SelectionListener)new SelectionListener<ButtonEvent>(){
            private LogoutAction logoutAction;
            {
                this.logoutAction = new LogoutAction(SimpleModeHeader.this.viewContext);
            }

            public void componentSelected(ButtonEvent ce) {
                this.logoutAction.execute();
            }
        });
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        this.refresh();
    }
}

