/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AuthorizationGroupSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.PersonSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc.RoleListBox;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.form.AdapterField;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;

public class AddRoleAssignmentDialog
extends AbstractRegistrationDialog {
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    static final String PREFIX = "openbis_add-role_";
    static final String ROLE_FIELD_ID = "openbis_add-role_role-field";
    static final String AUTH_GROUP_RADIO = "openbis_add-role_auth-group-rd";
    private final SpaceSelectionWidget group;
    private final PersonSelectionWidget person;
    private final AdapterField roleBox;
    private Radio authGroupRadio;
    private Radio personRadio;
    private AuthorizationGroupSelectionWidget authGroup;

    public AddRoleAssignmentDialog(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedAction postRegistrationCallback) {
        super(viewContext, "Assign authorization role to the user or the group of users", postRegistrationCallback);
        this.viewContext = viewContext;
        this.group = new SpaceSelectionWidget(viewContext, PREFIX, false, false);
        this.group.setWidth(100);
        this.roleBox = new AdapterField((Widget)new RoleListBox(this.group));
        this.roleBox.setFieldLabel("Role");
        this.roleBox.setWidth(100);
        this.roleBox.setId(ROLE_FIELD_ID);
        this.addField((Widget)this.roleBox);
        this.addField((Widget)this.group);
        RadioGroup radioGroup = new RadioGroup();
        radioGroup.setFieldLabel("Grantee Type");
        this.authGroupRadio = new Radio();
        this.authGroupRadio.setBoxLabel("Authorization Group");
        this.authGroupRadio.setId(AUTH_GROUP_RADIO);
        this.personRadio = new Radio();
        this.personRadio.setBoxLabel("Person");
        this.personRadio.setValue(Boolean.valueOf(true));
        radioGroup.add(this.authGroupRadio);
        radioGroup.add(this.personRadio);
        this.addField((Widget)radioGroup);
        this.person = new PersonSelectionWidget(viewContext, PREFIX);
        FieldUtil.markAsMandatory(this.person);
        this.addField((Widget)this.person);
        this.authGroup = new AuthorizationGroupSelectionWidget(viewContext, PREFIX);
        FieldUtil.markAsMandatory(this.authGroup);
        this.addField((Widget)this.authGroup);
        GWTUtils.updateVisibleField(this.personRadio.getValue(), this.authGroupRadio.getValue(), this.person, this.authGroup);
        radioGroup.addListener(Events.Change, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                GWTUtils.updateVisibleField(AddRoleAssignmentDialog.this.personRadio.getValue(), AddRoleAssignmentDialog.this.authGroupRadio.getValue(), AddRoleAssignmentDialog.this.person, AddRoleAssignmentDialog.this.authGroup);
            }
        });
        DialogWithOnlineHelpUtils.addHelpButton(viewContext, this, this.createHelpPageIdentifier());
    }

    @Override
    protected void register(AsyncCallback<Void> registrationCallback) {
        Grantee grantee;
        Grantee grantee2 = grantee = this.personRadio.getValue() != false ? Grantee.createPerson(this.person.tryGetSelectedPersonCode()) : Grantee.createAuthorizationGroup(this.authGroup.tryGetSelectedAuthorizationGroupCode());
        if (!((RoleListBox)this.roleBox.getWidget()).getValue().isSpaceLevel()) {
            this.viewContext.getService().registerInstanceRole(((RoleListBox)this.roleBox.getWidget()).getValue(), grantee, registrationCallback);
        } else {
            Space spaceOrNull = this.group.tryGetSelectedSpace();
            this.viewContext.getService().registerSpaceRole(((RoleListBox)this.roleBox.getWidget()).getValue(), spaceOrNull.getCode(), grantee, registrationCallback);
        }
    }

    private HelpPageIdentifier createHelpPageIdentifier() {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ROLES, HelpPageIdentifier.HelpPageAction.REGISTER);
    }
}

