/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.amc;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.SpaceSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.client.ui.ListBox;
import java.util.ArrayList;
import java.util.List;

public class RoleListBox
extends ListBox {
    private List<RoleWithHierarchy> roles;

    public RoleListBox(final SpaceSelectionWidget groupWidget) {
        for (RoleWithHierarchy visibleRoleCode : this.getRoles()) {
            this.addItem(visibleRoleCode.toString());
        }
        this.setVisibleItemCount(1);
        this.updateWidgetsVisibility(groupWidget);
        this.addChangeHandler(new ChangeHandler(){

            public final void onChange(ChangeEvent sender) {
                RoleListBox.this.updateWidgetsVisibility(groupWidget);
            }
        });
    }

    public final RoleWithHierarchy getValue() {
        return this.getRoles().get(this.getSelectedIndex());
    }

    private void updateWidgetsVisibility(SpaceSelectionWidget group) {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getRoles().size()) {
            return;
        }
        boolean groupLevel = this.getRoles().get(index).isSpaceLevel();
        FieldUtil.setMandatoryFlag(group, groupLevel);
        group.setVisible(groupLevel);
    }

    private List<RoleWithHierarchy> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<RoleWithHierarchy>();
            RoleWithHierarchy[] roleWithHierarchyArray = RoleWithHierarchy.values();
            int n = roleWithHierarchyArray.length;
            int n2 = 0;
            while (n2 < n) {
                RoleWithHierarchy role = roleWithHierarchyArray[n2];
                if (!RoleWithHierarchy.INSTANCE_DISABLED.equals(role)) {
                    this.roles.add(role);
                }
                ++n2;
            }
        }
        return this.roles;
    }
}

