/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataSetTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;

public final class DataSetBatchUpdatePanel
extends LayoutContainer {
    private static final String ID_SUFFIX = "data-set-batch-update";
    public static final String ID = "openbis_data-set-batch-update";
    private final DataSetTypeSelectionWidget dataSetTypeSelection;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        DataSetBatchUpdatePanel panel = new DataSetBatchUpdatePanel(viewContext);
        return new DatabaseModificationAwareComponent((Component)panel, (IDatabaseModificationObserver)panel.dataSetTypeSelection);
    }

    private DataSetBatchUpdatePanel(final IViewContext<ICommonClientServiceAsync> viewContext) {
        this.viewContext = viewContext;
        this.setId(ID);
        this.setScrollMode(Style.Scroll.AUTO);
        this.dataSetTypeSelection = new DataSetTypeSelectionWidget(viewContext, ID_SUFFIX);
        final ToolBar toolBar = this.createToolBar();
        this.add((Component)toolBar);
        this.dataSetTypeSelection.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<DataSetTypeModel>(){

            public final void selectionChanged(SelectionChangedEvent<DataSetTypeModel> se) {
                DataSetType dataSetType = DataSetBatchUpdatePanel.this.dataSetTypeSelection.tryGetSelectedDataSetType();
                if (dataSetType != null) {
                    DataSetBatchUpdatePanel.this.removeAll();
                    EntityKind entityKind = EntityKind.DATA_SET;
                    DataSetBatchUpdatePanel.this.add((Component)toolBar);
                    IClientPlugin createClientPlugin = viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, dataSetType).createClientPlugin(entityKind);
                    Widget widget = createClientPlugin.createBatchUpdateForEntityType(dataSetType);
                    DataSetBatchUpdatePanel.this.add(widget);
                    DataSetBatchUpdatePanel.this.layout();
                }
            }
        });
    }

    private final ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)new LabelToolItem(String.valueOf(this.viewContext.getMessage("data_set_type", new Object[0])) + ":"));
        toolBar.add((Component)this.dataSetTypeSelection);
        return toolBar;
    }
}

