/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ShowResultSetCutInfo;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.AbstractExternalDataGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetGridUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DatastoreServiceDescriptionModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.ReportingPluginSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report.ReportGeneratedCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedDataSetSearchToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchWindow;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.IDetailedSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Set;

public class DataSetSearchHitGrid
extends AbstractExternalDataGrid
implements IDetailedSearchHitGrid {
    public static final String BROWSER_ID = "openbis_data-set-search-hit-browser";
    public static final String GRID_ID = "openbis_data-set-search-hit-browser-grid";
    private DetailedSearchCriteria chosenSearchCriteria;
    private final boolean forChooser;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        return DataSetSearchHitGrid.create(viewContext, null, false);
    }

    public static DisposableEntityChooser<TableModelRowWithObject<AbstractExternalData>> createWithInitialSearchCriteria(IViewContext<ICommonClientServiceAsync> viewContext, DetailedSearchCriteria searchCriteria, boolean forChooser) {
        return DataSetSearchHitGrid.create(viewContext, searchCriteria, forChooser);
    }

    private static DisposableEntityChooser<TableModelRowWithObject<AbstractExternalData>> create(IViewContext<ICommonClientServiceAsync> viewContext, DetailedSearchCriteria searchCriteriaOrNull, boolean forChooser) {
        DataSetSearchHitGrid grid = new DataSetSearchHitGrid(viewContext, forChooser);
        DetailedSearchWindow searchWindow = new DetailedSearchWindow(viewContext, EntityKind.DATA_SET);
        if (searchCriteriaOrNull != null) {
            grid.chosenSearchCriteria = searchCriteriaOrNull;
            searchWindow.setInitialSearchCriteria(searchCriteriaOrNull);
        }
        DisposableEntityChooser metadataComponent = grid.asDisposableWithoutToolbar();
        LayoutContainerWithDisposableComponent containerHolder = DataSetSearchHitGrid.createContainerHolder(metadataComponent);
        ReportGeneratedCallback.IOnReportComponentGeneratedAction reportGeneratedAction = DataSetSearchHitGrid.createReportGeneratedAction(containerHolder, grid);
        ReportingPluginSelectionWidget reportSelectionWidget = new ReportingPluginSelectionWidget(viewContext, null);
        SelectionChangedListener<DatastoreServiceDescriptionModel> reportChangedListener = DataSetGridUtils.createReportSelectionChangedListener(viewContext, grid.asDisposableWithoutToolbar(), reportGeneratedAction);
        reportSelectionWidget.addSelectionChangedListener(reportChangedListener);
        DetailedDataSetSearchToolbar toolbar = new DetailedDataSetSearchToolbar(viewContext, grid, viewContext.getMessage("button_change_query", new Object[0]), searchWindow, reportSelectionWidget, searchCriteriaOrNull != null);
        searchWindow.setUpdateListener(toolbar);
        return grid.asDisposableWithToolbar(containerHolder, toolbar);
    }

    private static LayoutContainerWithDisposableComponent createContainerHolder(IDisposableComponent metadataComponent) {
        LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new RowLayout());
        return new LayoutContainerWithDisposableComponent(container, metadataComponent);
    }

    private static ReportGeneratedCallback.IOnReportComponentGeneratedAction createReportGeneratedAction(final LayoutContainerWithDisposableComponent containerHolder, final DataSetSearchHitGrid metadataGrid) {
        return new ReportGeneratedCallback.IOnReportComponentGeneratedAction(){

            @Override
            public void execute(IDisposableComponent newGridComponent) {
                LayoutContainer container = containerHolder.getContainer();
                IDisposableComponent disposableComponent = containerHolder.getDisposableComponent();
                Widget widget = container.getWidget(1);
                container.remove(widget);
                if (disposableComponent != null && !disposableComponent.getComponent().equals(metadataGrid)) {
                    disposableComponent.dispose();
                }
                containerHolder.setDisposableComponent(newGridComponent);
                container.add((Widget)newGridComponent.getComponent(), (LayoutData)new RowData(1.0, 1.0));
                container.layout();
            }
        };
    }

    private DataSetSearchHitGrid(IViewContext<ICommonClientServiceAsync> viewContext, boolean forChooser) {
        super(viewContext, BROWSER_ID, GRID_ID, DisplayTypeIDGenerator.DATA_SET_SEARCH_RESULT_GRID);
        this.forChooser = forChooser;
        if (forChooser) {
            this.disallowMultipleSelection();
        }
    }

    @Override
    protected ICellListenerAndLinkGenerator<AbstractExternalData> tryGetCellListenerAndLinkGenerator(String columnId) {
        if (this.forChooser) {
            return null;
        }
        return super.tryGetCellListenerAndLinkGenerator(columnId);
    }

    @Override
    protected boolean isEditable(BaseEntityModel<TableModelRowWithObject<AbstractExternalData>> model, String columnID) {
        return this.forChooser ? false : super.isEditable(model, columnID);
    }

    @Override
    protected void showNonEditableTableCellMessage(BaseEntityModel<TableModelRowWithObject<AbstractExternalData>> model, String columnID) {
        if (this.forChooser) {
            return;
        }
        super.showNonEditableTableCellMessage(model, columnID);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<AbstractExternalData>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<AbstractExternalData>> callback) {
        callback.addOnSuccessAction(new ShowResultSetCutInfo(this.viewContext));
        ((ICommonClientServiceAsync)this.viewContext.getService()).searchForDataSets(this.chosenSearchCriteria, resultSetConfig, callback);
    }

    @Override
    public void refresh(DetailedSearchCriteria newCriteria, List<PropertyType> propertyTypes) {
        this.chosenSearchCriteria = newCriteria;
        this.refresh();
    }

    @Override
    protected void refresh() {
        if (this.chosenSearchCriteria == null) {
            return;
        }
        super.refresh();
    }

    private DisposableEntityChooser<TableModelRowWithObject<AbstractExternalData>> asDisposableWithToolbar(LayoutContainerWithDisposableComponent containerHolder, IDisposableComponent toolbar) {
        LayoutContainer container = containerHolder.getContainer();
        container.add((Widget)toolbar.getComponent());
        container.add((Widget)this, (LayoutData)new RowData(1.0, 1.0));
        IDisposableComponent dynamicComponentProvider = this.createDynamicComponentProvider(containerHolder);
        return this.asDisposableEntityChooser((Component)container, toolbar, dynamicComponentProvider);
    }

    private IDisposableComponent createDynamicComponentProvider(final LayoutContainerWithDisposableComponent containerHolder) {
        return new IDisposableComponent(){

            private IDisposableComponent getDisposableComponent() {
                return containerHolder.getDisposableComponent();
            }

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications) {
                this.getDisposableComponent().update(observedModifications);
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return this.getDisposableComponent().getRelevantModifications();
            }

            @Override
            public Component getComponent() {
                return this.getDisposableComponent().getComponent();
            }

            @Override
            public void dispose() {
                this.getDisposableComponent().dispose();
            }
        };
    }

    private static class LayoutContainerWithDisposableComponent {
        private final LayoutContainer container;
        private IDisposableComponent disposableComponent;

        public LayoutContainerWithDisposableComponent(LayoutContainer container, IDisposableComponent component) {
            this.container = container;
            this.disposableComponent = component;
        }

        public IDisposableComponent getDisposableComponent() {
            return this.disposableComponent;
        }

        public void setDisposableComponent(IDisposableComponent disposableComponent) {
            this.disposableComponent = disposableComponent;
        }

        public LayoutContainer getContainer() {
            return this.container;
        }
    }
}

