/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SimplifiedBaseModelData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.FileFormatType;
import java.util.ArrayList;
import java.util.List;

public final class FileFormatTypeSelectionWidget
extends DropDownList<FileFormatTypeModel, FileFormatType> {
    private static final String EMPTY_RESULT_SUFFIX = "file format types";
    private static final String CHOOSE_SUFFIX = "file format type";
    public static final String SUFFIX = "file-format-type";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private static final String DISPLAY_COLUMN_ID = "code";

    public FileFormatTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix) {
        super(viewContext, SUFFIX + idSuffix, "file_format_type", DISPLAY_COLUMN_ID, CHOOSE_SUFFIX, EMPTY_RESULT_SUFFIX);
        this.viewContext = viewContext;
    }

    public final FileFormatType tryGetSelectedFileFormatType() {
        return (FileFormatType)super.tryGetSelected();
    }

    @Override
    protected List<FileFormatTypeModel> convertItems(List<FileFormatType> types) {
        ArrayList<FileFormatTypeModel> result = new ArrayList<FileFormatTypeModel>();
        for (FileFormatType type : types) {
            result.add(new FileFormatTypeModel(type));
        }
        return result;
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<FileFormatType>> callback) {
        this.viewContext.getService().listFileTypes(callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.FILE_FORMAT_TYPE);
    }

    public static class FileFormatTypeModel
    extends SimplifiedBaseModelData {
        private static final long serialVersionUID = 1L;

        public FileFormatTypeModel(FileFormatType type) {
            this.set(FileFormatTypeSelectionWidget.DISPLAY_COLUMN_ID, type.getCode());
            this.set("object", type);
        }
    }
}

