/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.EmptyTrashButton;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.PermanentDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.deletion.RevertDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DeletionGrid
extends TypedTableGrid<Deletion> {
    public static final String BROWSER_ID = "openbis_deletion-browser";
    public static final String GRID_ID = "openbis_deletion-browser-grid";

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        DeletionGrid grid = new DeletionGrid(viewContext);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private DeletionGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.DELETION_BROWSER_GRID);
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button revertButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_revert_deletion", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<Deletion>> data, IBrowserGridActionInvoker invoker) {
                ArrayList<Deletion> deletions = new ArrayList<Deletion>();
                for (TableModelRowWithObject<Deletion> row : data) {
                    deletions.add(row.getObjectOrNull());
                }
                return new RevertDeletionConfirmationDialog((IViewContext<ICommonClientServiceAsync>)DeletionGrid.this.viewContext, deletions, (AsyncCallback<Void>)DeletionGrid.this.createRefreshCallback(invoker));
            }
        });
        this.addButton(revertButton);
        EmptyTrashButton emptyTrashButtonMenu = new EmptyTrashButton(this.viewContext, this.createRefreshCallback(this.asActionInvoker()));
        emptyTrashButtonMenu.setId("empty-trash-button");
        this.addButton(emptyTrashButtonMenu);
        final Button deletePermanentlyButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete_permanently", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<Deletion>> data, IBrowserGridActionInvoker invoker) {
                ArrayList<Deletion> deletions = new ArrayList<Deletion>();
                for (TableModelRowWithObject<Deletion> row : data) {
                    deletions.add(row.getObjectOrNull());
                }
                return new PermanentDeletionConfirmationDialog((IViewContext<ICommonClientServiceAsync>)DeletionGrid.this.viewContext, deletions, (AsyncCallback<Void>)DeletionGrid.this.createRefreshCallback(invoker));
            }
        });
        this.addButton(deletePermanentlyButton);
        this.allowMultipleSelection();
        this.addGridSelectionChangeListener(new Listener<SelectionChangedEvent<ModelData>>(){

            public void handleEvent(SelectionChangedEvent<ModelData> be) {
                deletePermanentlyButton.setEnabled(be.getSelection().size() == 1);
            }
        });
        this.addEntityOperationsSeparator();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Deletion>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Deletion>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("ENTITIES", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("REASON", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("DELETER", PersonRenderer.REGISTRATOR_RENDERER);
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Deletion>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Deletion>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listDeletions(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Deletion>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportDeletions(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("DELETER", "REASON");
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<Deletion> row, boolean editMode, boolean inBackground) {
        throw new UserFailureException("Operation is not supported.");
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.DELETION)};
    }
}

