/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IComponentWithCloseConfirmation;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.MainTabPanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataSetKindModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.BorderLayoutDataFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.DataSetKindSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.data.DataSetTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AbstractEntityTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.entity_type.AddEntityTypeDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.PropertyTypeAssignmentGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FormPanelWithSavePoint;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETNewPTAssigments;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewPTNewAssigment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class NewEntityTypeForm
extends ContentPanel
implements IComponentWithCloseConfirmation {
    public static final String BROWSER_ID = "openbis_new-entity-type-form";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final EntityKind kind;
    private EntityType entityToEdit;
    private NewETNewPTAssigments newTypeWithAssigments;
    private final ComponentProvider componentProvider;
    private FormPanelWithSavePoint dialogForm;
    private PropertyTypeAssignmentGrid propertyGrid;
    private AbstractEntityTypeGrid<? extends EntityType> typeGrid;
    private Button saveButton;
    private Html unsavedChangesInfo;
    private boolean shouldAskForCloseConfirmation = true;

    private NewEntityTypeForm(EntityKind kind, EntityType entityToEdit, IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        this.kind = kind;
        this.viewContext = viewContext;
        this.componentProvider = componentProvider;
        this.setLayout((Layout)new BorderLayout());
        this.setHeaderVisible(false);
        this.setBorders(false);
        this.setBodyBorder(false);
        if (entityToEdit != null) {
            this.loadEntityTypeToEdit(this, entityToEdit);
        } else {
            this.initForm();
        }
    }

    private void loadEntityTypeToEdit(NewEntityTypeForm newEntityTypeForm, EntityType entityToEdit) {
        switch (this.kind) {
            case SAMPLE: {
                this.viewContext.getCommonService().listSampleTypes(new LoadCallBack<SampleType>(newEntityTypeForm, entityToEdit));
                break;
            }
            case DATA_SET: {
                this.viewContext.getCommonService().listDataSetTypes(new LoadCallBack<DataSetType>(newEntityTypeForm, entityToEdit));
                break;
            }
            case EXPERIMENT: {
                this.viewContext.getCommonService().listExperimentTypes(new LoadCallBack<ExperimentType>(newEntityTypeForm, entityToEdit));
                break;
            }
            case MATERIAL: {
                this.viewContext.getCommonService().listMaterialTypes(new LoadCallBack<MaterialType>(newEntityTypeForm, entityToEdit));
            }
        }
    }

    public static DatabaseModificationAwareComponent create(EntityKind kind, EntityType entityToEdit, IViewContext<ICommonClientServiceAsync> viewContext, ComponentProvider componentProvider) {
        NewEntityTypeForm form = new NewEntityTypeForm(kind, entityToEdit, viewContext, componentProvider);
        return new DatabaseModificationAwareComponent((Component)form, (IDatabaseModificationObserver)new CompositeDatabaseModificationObserver());
    }

    private void initForm() {
        this.removeAll();
        this.newTypeWithAssigments = new NewETNewPTAssigments();
        this.newTypeWithAssigments.setAssigments(new ArrayList<NewPTNewAssigment>());
        this.initEntityTypeForm();
        if (this.entityToEdit == null) {
            this.initCreateEntity();
        } else {
            this.initEditEntity();
        }
        this.dialogForm.setHeaderVisible(true);
        this.dialogForm.setHeading("Entity Type Information:");
        this.dialogForm.setBorders(false);
        this.dialogForm.setBodyBorder(false);
        this.dialogForm.setLabelWidth(180);
        this.add((Widget)this.dialogForm, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.NORTH, 370.0f));
        this.propertyGrid = (PropertyTypeAssignmentGrid)PropertyTypeAssignmentGrid.create(this.viewContext, null, this.newTypeWithAssigments, this.entityToEdit != null).getComponent();
        this.propertyGrid.setLayoutOnChange(true);
        ContentPanel gridPanel = new ContentPanel();
        gridPanel.setLayout((Layout)new BorderLayout());
        gridPanel.setLayoutOnChange(true);
        gridPanel.setHeaderVisible(true);
        gridPanel.setHeading("Assigned Property Types:");
        gridPanel.setBorders(false);
        gridPanel.setBodyBorder(false);
        gridPanel.add((Widget)this.propertyGrid, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.CENTER, 170.0f));
        this.add((Widget)gridPanel, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.CENTER, 170.0f));
        ContentPanel bottomPanel = new ContentPanel();
        bottomPanel.setLayout((Layout)new BorderLayout());
        bottomPanel.setLayoutOnChange(false);
        bottomPanel.setHeaderVisible(false);
        bottomPanel.setBorders(false);
        bottomPanel.setBodyBorder(false);
        ButtonBar buttonBar = new ButtonBar();
        buttonBar.setMinButtonWidth(100);
        buttonBar.setAlignment(Style.HorizontalAlignment.RIGHT);
        this.unsavedChangesInfo = this.createUnsavedChangesInfo();
        this.dialogForm.addDirtyChangeListener(new Listener<FormPanelWithSavePoint.DirtyChangeEvent>(){

            public void handleEvent(FormPanelWithSavePoint.DirtyChangeEvent be) {
                NewEntityTypeForm.this.unsavedChangesInfo.setVisible(NewEntityTypeForm.this.isDirty());
            }
        });
        this.propertyGrid.addDirtyChangeListener(new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent event) {
                NewEntityTypeForm.this.unsavedChangesInfo.setVisible(NewEntityTypeForm.this.isDirty());
            }
        });
        buttonBar.add((Component)this.unsavedChangesInfo);
        this.saveButton = this.createSaveButton();
        this.saveButton.setStyleAttribute("padding-right", "10px");
        buttonBar.add((Component)this.saveButton);
        bottomPanel.add((Widget)buttonBar, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.EAST, 300.0f));
        this.add((Widget)bottomPanel, (LayoutData)BorderLayoutDataFactory.create(Style.LayoutRegion.SOUTH, 30.0f));
        this.layout();
    }

    private void initEntityTypeForm() {
        AddEntityTypeDialog<EntityType> dialog = null;
        switch (this.kind) {
            case SAMPLE: {
                this.typeGrid = (SampleTypeGrid)SampleTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((SampleTypeGrid)this.typeGrid).getNewDialog(new SampleType());
                break;
            }
            case DATA_SET: {
                this.typeGrid = (DataSetTypeGrid)DataSetTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((DataSetTypeGrid)this.typeGrid).getNewDialog(new DataSetType());
                break;
            }
            case EXPERIMENT: {
                this.typeGrid = (ExperimentTypeGrid)ExperimentTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((ExperimentTypeGrid)this.typeGrid).getNewDialog(new ExperimentType());
                break;
            }
            case MATERIAL: {
                this.typeGrid = (MaterialTypeGrid)MaterialTypeGrid.create(this.viewContext, this.componentProvider).getComponent();
                dialog = ((MaterialTypeGrid)this.typeGrid).getNewDialog(new MaterialType());
            }
        }
        List dialogFormIntoList = dialog.getItems();
        this.dialogForm = (FormPanelWithSavePoint)((Object)dialogFormIntoList.get(0));
    }

    private void initCreateEntity() {
        switch (this.kind) {
            case SAMPLE: {
                SampleType sampleType = new SampleType();
                sampleType.setSampleTypePropertyTypes(new ArrayList<SampleTypePropertyType>());
                this.newTypeWithAssigments.setEntity(sampleType);
                break;
            }
            case DATA_SET: {
                DataSetType dataSetType = new DataSetType();
                dataSetType.setDataSetTypePropertyTypes(new ArrayList<DataSetTypePropertyType>());
                this.newTypeWithAssigments.setEntity(dataSetType);
                break;
            }
            case EXPERIMENT: {
                ExperimentType experimentType = new ExperimentType();
                experimentType.setExperimentTypePropertyTypes(new ArrayList<ExperimentTypePropertyType>());
                this.newTypeWithAssigments.setEntity(experimentType);
                break;
            }
            case MATERIAL: {
                MaterialType materialType = new MaterialType();
                materialType.setMaterialTypePropertyTypes(new ArrayList<MaterialTypePropertyType>());
                this.newTypeWithAssigments.setEntity(materialType);
            }
        }
        this.newTypeWithAssigments.getEntity().setCode("" + System.currentTimeMillis());
    }

    private void initEditEntity() {
        List formFields = this.dialogForm.getFields();
        ((CodeField)((Object)formFields.get(0))).setValue(this.entityToEdit.getCode());
        ((CodeField)((Object)formFields.get(0))).setEnabled(false);
        FieldUtil.setValueWithUnescaping((Field<String>)((DescriptionField)((Object)formFields.get(1))), this.entityToEdit.getDescription());
        if (this.entityToEdit.getValidationScript() != null) {
            ((ScriptChooserField)formFields.get(2)).setValue(this.entityToEdit.getValidationScript().getName());
        }
        switch (this.kind) {
            case SAMPLE: {
                SampleType sampleToEdit = (SampleType)this.entityToEdit;
                ((CheckBoxField)((Object)formFields.get(3))).setValue(sampleToEdit.isListable());
                ((CheckBoxField)((Object)formFields.get(4))).setValue(sampleToEdit.isShowContainer());
                ((CheckBoxField)((Object)formFields.get(5))).setValue(sampleToEdit.isShowParents());
                ((CheckBoxField)((Object)formFields.get(6))).setValue(sampleToEdit.isSubcodeUnique());
                ((CheckBoxField)((Object)formFields.get(7))).setValue(sampleToEdit.isAutoGeneratedCode());
                ((CheckBoxField)((Object)formFields.get(8))).setValue(sampleToEdit.isShowParentMetadata());
                ((TextField)formFields.get(9)).setValue((Object)sampleToEdit.getGeneratedCodePrefix());
                break;
            }
            case DATA_SET: {
                DataSetType datasetToEdit = (DataSetType)this.entityToEdit;
                ((DataSetKindSelectionWidget)formFields.get(3)).setValue((ModelData)new DataSetKindModel(datasetToEdit.getDataSetKind()));
                ((DataSetKindSelectionWidget)formFields.get(3)).setEnabled(false);
                ((CheckBoxField)((Object)formFields.get(4))).setValue(datasetToEdit.isDeletionDisallow());
                FieldUtil.setValueWithUnescaping((Field<String>)((TextField)formFields.get(5)), datasetToEdit.getMainDataSetPattern());
                FieldUtil.setValueWithUnescaping((Field<String>)((TextField)formFields.get(6)), datasetToEdit.getMainDataSetPath());
            }
        }
        this.newTypeWithAssigments.setEntity(this.entityToEdit);
        int i = 0;
        while (i < this.entityToEdit.getAssignedPropertyTypes().size()) {
            NewPTNewAssigment assigment = new NewPTNewAssigment();
            assigment.setExistingPropertyType(true);
            assigment.setPropertyType(this.entityToEdit.getAssignedPropertyTypes().get(i).getPropertyType());
            NewETPTAssignment newETPTAssigment = new NewETPTAssignment();
            newETPTAssigment.setPropertyTypeCode(this.entityToEdit.getAssignedPropertyTypes().get(i).getPropertyType().getCode());
            newETPTAssigment.setEntityKind(this.entityToEdit.getEntityKind());
            newETPTAssigment.setOrdinal(this.entityToEdit.getAssignedPropertyTypes().get(i).getOrdinal());
            newETPTAssigment.setSection(this.entityToEdit.getAssignedPropertyTypes().get(i).getSection());
            newETPTAssigment.setMandatory(this.entityToEdit.getAssignedPropertyTypes().get(i).isMandatory());
            newETPTAssigment.setDynamic(this.entityToEdit.getAssignedPropertyTypes().get(i).isDynamic());
            newETPTAssigment.setManaged(this.entityToEdit.getAssignedPropertyTypes().get(i).isManaged());
            newETPTAssigment.setShownInEditView(this.entityToEdit.getAssignedPropertyTypes().get(i).isShownInEditView());
            newETPTAssigment.setShowRawValue(this.entityToEdit.getAssignedPropertyTypes().get(i).getShowRawValue());
            newETPTAssigment.setModificationDate(this.entityToEdit.getAssignedPropertyTypes().get(i).getModificationDate());
            assigment.setAssignment(newETPTAssigment);
            if (this.entityToEdit.getAssignedPropertyTypes().get(i).getScript() != null) {
                assigment.getAssignment().setScriptName(this.entityToEdit.getAssignedPropertyTypes().get(i).getScript().getName());
            }
            this.newTypeWithAssigments.getAssigments().add(assigment);
            ++i;
        }
        this.newTypeWithAssigments.updateOrdinalToGridOrder();
    }

    private Button createSaveButton() {
        Button save = new Button("Save", (SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (NewEntityTypeForm.this.dialogForm.isValid()) {
                    NewEntityTypeForm.this.saveButton.setEnabled(false);
                    NewEntityTypeForm.this.setEntityFromForm();
                    for (NewPTNewAssigment assigment : NewEntityTypeForm.this.newTypeWithAssigments.getAssigments()) {
                        assigment.getAssignment().setEntityTypeCode(NewEntityTypeForm.this.newTypeWithAssigments.getEntity().getCode());
                    }
                    if (NewEntityTypeForm.this.entityToEdit == null) {
                        ((ICommonClientServiceAsync)NewEntityTypeForm.this.viewContext.getService()).registerEntitytypeAndAssignPropertyTypes(NewEntityTypeForm.this.newTypeWithAssigments, new AsyncCallbackEntityType());
                    } else {
                        ((ICommonClientServiceAsync)NewEntityTypeForm.this.viewContext.getService()).updateEntitytypeAndPropertyTypes(NewEntityTypeForm.this.newTypeWithAssigments, new AsyncCallbackEntityType());
                    }
                }
            }
        });
        return save;
    }

    private void setEntityFromForm() {
        List formFields = this.dialogForm.getFields();
        switch (this.kind) {
            case SAMPLE: {
                SampleType toSaveSample = (SampleType)this.newTypeWithAssigments.getEntity();
                toSaveSample.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveSample.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveSample.setValidationScript(script);
                }
                toSaveSample.setListable((Boolean)((Field)formFields.get(3)).getValue());
                toSaveSample.setShowContainer((Boolean)((Field)formFields.get(4)).getValue());
                toSaveSample.setShowParents((Boolean)((Field)formFields.get(5)).getValue());
                toSaveSample.setSubcodeUnique((Boolean)((Field)formFields.get(6)).getValue());
                toSaveSample.setAutoGeneratedCode((Boolean)((Field)formFields.get(7)).getValue());
                toSaveSample.setShowParentMetadata((Boolean)((Field)formFields.get(8)).getValue());
                toSaveSample.setGeneratedCodePrefix((String)((Field)formFields.get(9)).getValue());
                this.newTypeWithAssigments.setEntity(toSaveSample);
                break;
            }
            case DATA_SET: {
                DataSetType toSaveDataSet = (DataSetType)this.newTypeWithAssigments.getEntity();
                toSaveDataSet.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveDataSet.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveDataSet.setValidationScript(script);
                }
                toSaveDataSet.setDataSetKind(((DataSetKindModel)((Object)((DataSetKindSelectionWidget)formFields.get(3)).getValue())).getBaseObject());
                toSaveDataSet.setDeletionDisallow((Boolean)((Field)formFields.get(4)).getValue());
                toSaveDataSet.setMainDataSetPattern((String)((Field)formFields.get(5)).getValue());
                toSaveDataSet.setMainDataSetPath((String)((Field)formFields.get(6)).getValue());
                this.newTypeWithAssigments.setEntity(toSaveDataSet);
                break;
            }
            case EXPERIMENT: {
                ExperimentType toSaveExperiment = (ExperimentType)this.newTypeWithAssigments.getEntity();
                toSaveExperiment.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveExperiment.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveExperiment.setValidationScript(script);
                }
                this.newTypeWithAssigments.setEntity(toSaveExperiment);
                break;
            }
            case MATERIAL: {
                MaterialType toSaveMaterial = (MaterialType)this.newTypeWithAssigments.getEntity();
                toSaveMaterial.setCode((String)((Field)formFields.get(0)).getValue());
                toSaveMaterial.setDescription((String)((Field)formFields.get(1)).getValue());
                if (((Field)formFields.get(2)).getValue() != null) {
                    Script script = new Script();
                    script.setName((String)((Field)formFields.get(2)).getValue());
                    toSaveMaterial.setValidationScript(script);
                }
                this.newTypeWithAssigments.setEntity(toSaveMaterial);
            }
        }
    }

    public static String getTabId(EntityKind kind, EntityType type) {
        if (type == null) {
            return "openbis_new-entity-type-form-" + kind.name() + "-New";
        }
        return "openbis_new-entity-type-form-" + kind.name() + "-" + type.getCode();
    }

    private Html createUnsavedChangesInfo() {
        Html result = new Html(this.viewContext.getMessage("unsaved_form_changes_info", new Object[0]));
        result.addStyleName("unsaved-changes-info");
        result.setVisible(false);
        return result;
    }

    private boolean isDirty() {
        return this.dialogForm.isDirtyForSavePoint() || this.propertyGrid.isDirty();
    }

    @Override
    public boolean shouldAskForCloseConfirmation() {
        return this.shouldAskForCloseConfirmation && this.isDirty();
    }

    private class AsyncCallbackEntityType
    implements AsyncCallback<String> {
        private AsyncCallbackEntityType() {
        }

        public void onFailure(Throwable throwable) {
            UserFailureException userException;
            String details;
            String message = "Error";
            if (throwable instanceof UserFailureException && (details = GWTUtils.translateToHtmlLineBreaks((userException = (UserFailureException)throwable).getMessage())) != null) {
                message = details;
            }
            MessageBox.alert((String)"Error", (String)message, null);
            NewEntityTypeForm.this.saveButton.setEnabled(true);
        }

        public void onSuccess(String result) {
            if (NewEntityTypeForm.this.entityToEdit == null) {
                MessageBox.info((String)"Success", (String)"Registration Successful.", null);
            } else {
                MessageBox.info((String)"Success", (String)"Update Successful.", null);
            }
            NewEntityTypeForm.this.shouldAskForCloseConfirmation = false;
            MainTabPanel tabPanel = (MainTabPanel)NewEntityTypeForm.this.componentProvider.tryGetMainTabPanel();
            String getTabId = String.valueOf(NewEntityTypeForm.getTabId(NewEntityTypeForm.this.kind, NewEntityTypeForm.this.entityToEdit)) + "_tab";
            TabItem item = (TabItem)tabPanel.getItemByItemId(getTabId);
            item.close();
        }
    }

    private class LoadCallBack<K extends EntityType>
    implements AsyncCallback<List<K>> {
        final NewEntityTypeForm newEntityTypeForm;
        final EntityType entityToEdit;

        public LoadCallBack(NewEntityTypeForm newEntityTypeForm2, EntityType entityToEdit) {
            this.newEntityTypeForm = newEntityTypeForm2;
            this.entityToEdit = entityToEdit;
        }

        public void onSuccess(List<K> result) {
            for (EntityType entityType : result) {
                if (!entityType.getCode().equals(this.entityToEdit.getCode())) continue;
                this.newEntityTypeForm.entityToEdit = entityType;
                break;
            }
            NewEntityTypeForm.this.initForm();
        }

        public void onFailure(Throwable caught) {
        }
    }
}

