/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.ExperimentTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.experiment.ExperimentTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;

public final class ExperimentBatchRegistrationPanel
extends LayoutContainer {
    private static final String ID_SUFFIX = "experiment-batch-registration";
    public static final String ID = "openbis_experiment-batch-registration";
    private final ExperimentTypeSelectionWidget experimentTypeSelection;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public static String getId(boolean update) {
        return "openbis_experiment-batch-registration_" + (update ? "update" : "registration");
    }

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, boolean update) {
        ExperimentBatchRegistrationPanel panel = new ExperimentBatchRegistrationPanel(viewContext, update);
        return new DatabaseModificationAwareComponent((Component)panel, (IDatabaseModificationObserver)panel.experimentTypeSelection);
    }

    private ExperimentBatchRegistrationPanel(final IViewContext<ICommonClientServiceAsync> viewContext, final boolean update) {
        this.viewContext = viewContext;
        this.setId(ExperimentBatchRegistrationPanel.getId(update));
        this.setScrollMode(Style.Scroll.AUTO);
        this.experimentTypeSelection = new ExperimentTypeSelectionWidget(viewContext, ID_SUFFIX, null);
        final ToolBar toolBar = this.createToolBar();
        this.add((Component)toolBar);
        this.experimentTypeSelection.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<ExperimentTypeModel>(){

            public final void selectionChanged(SelectionChangedEvent<ExperimentTypeModel> se) {
                ExperimentType experimentType = ExperimentBatchRegistrationPanel.this.experimentTypeSelection.tryGetSelectedExperimentType();
                if (experimentType != null) {
                    ExperimentBatchRegistrationPanel.this.removeAll();
                    EntityKind entityKind = EntityKind.EXPERIMENT;
                    ExperimentBatchRegistrationPanel.this.add((Component)toolBar);
                    IClientPluginFactory clientPluginFactory = viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, experimentType);
                    IClientPlugin createClientPlugin = clientPluginFactory.createClientPlugin(entityKind);
                    Widget batchOperationWidget = update ? createClientPlugin.createBatchUpdateForEntityType(experimentType) : createClientPlugin.createBatchRegistrationForEntityType(experimentType);
                    ExperimentBatchRegistrationPanel.this.add(batchOperationWidget);
                    ExperimentBatchRegistrationPanel.this.layout();
                }
            }
        });
    }

    private final ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)new LabelToolItem(String.valueOf(this.viewContext.getMessage("experiment_type", new Object[0])) + ":"));
        toolBar.add((Component)this.experimentTypeSelection);
        return toolBar;
    }
}

