/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IChosenEntitiesSetter;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.ui.Widget;

class EntityChooserDialog<T>
extends SimpleDialog {
    private static final int WIDTH = 730;
    private static final int HEIGHT = 600;
    private final DisposableEntityChooser<T> entityBrowser;
    private final IDelegatedAction onAcceptAction;
    private final IDelegatedAction onCancelAction;

    public EntityChooserDialog(DisposableEntityChooser<T> entityBrowser, IChosenEntitiesSetter<T> chosenEntitySetter, String title, IMessageProvider messageProvider, Button ... buttons) {
        super((Widget)entityBrowser.getComponent(), title, messageProvider.getMessage("button_choose", new Object[0]), messageProvider, buttons);
        this.entityBrowser = entityBrowser;
        this.onAcceptAction = EntityChooserDialog.createAcceptAction(chosenEntitySetter, entityBrowser);
        this.onCancelAction = EntityChooserDialog.createCancelAction(chosenEntitySetter, entityBrowser);
        this.setWidth(730);
        this.setHeight(600);
        this.sinkEvents(2);
        this.setAcceptAction(this.onAcceptAction);
        this.setCancelAction(this.onCancelAction);
        this.setModal(true);
    }

    public void onComponentEvent(ComponentEvent ce) {
        if (ce.getType().getEventCode() == 2 && !this.entityBrowser.getSelected().isEmpty()) {
            this.onAcceptAction.execute();
            this.hide();
            return;
        }
        super.onComponentEvent(ce);
    }

    private static <T> IDelegatedAction createAcceptAction(final IChosenEntitiesSetter<T> chosenEntitySetter, final DisposableEntityChooser<T> entityBrowser) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                entityBrowser.dispose();
                chosenEntitySetter.setChosenEntities(entityBrowser.getSelected());
            }
        };
    }

    private static <T> IDelegatedAction createCancelAction(IChosenEntitiesSetter<T> chosenEntitySetter, final IDisposableComponent entityBrowser) {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                entityBrowser.dispose();
            }
        };
    }
}

