/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.VocabularyTermModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.DateRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DateFormField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.HyperlinkField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.IntegerField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MaterialChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.RealField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VocabularyTermSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.XmlField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.Date;

public class PropertyFieldFactory {
    public static DatabaseModificationAwareField<?> createField(PropertyType pt, boolean isMandatory, String label, String fieldId, String originalRawValue, IViewContext<ICommonClientServiceAsync> viewContext) {
        DatabaseModificationAwareField<?> fieldHolder = PropertyFieldFactory.doCreateField(pt, isMandatory, label, fieldId, originalRawValue, viewContext);
        Field field = (Field)fieldHolder.get();
        field.setId(fieldId);
        String description = pt.getDescription();
        if (!StringUtils.isBlank(description)) {
            AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)viewContext.getImageBundle().getInfoIcon());
            FieldUtil.addInfoIcon(field, description, infoIcon.createImage());
        }
        return fieldHolder;
    }

    private static DatabaseModificationAwareField<?> doCreateField(PropertyType pt, boolean isMandatory, String label, String fieldId, String originalRawValue, IViewContext<ICommonClientServiceAsync> viewContext) {
        DataTypeCode dataType = pt.getDataType().getCode();
        switch (dataType) {
            case BOOLEAN: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new CheckBoxField(label, isMandatory), originalRawValue));
            }
            case VARCHAR: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new VarcharField(label, isMandatory), originalRawValue));
            }
            case TIMESTAMP: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new DateFormField(label, isMandatory), originalRawValue));
            }
            case CONTROLLEDVOCABULARY: {
                return PropertyFieldFactory.createControlledVocabularyField(fieldId, label, pt.getVocabulary(), isMandatory, viewContext, originalRawValue);
            }
            case INTEGER: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new IntegerField(label, isMandatory), originalRawValue));
            }
            case REAL: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new RealField(label, isMandatory), originalRawValue));
            }
            case MATERIAL: {
                return PropertyFieldFactory.wrapUnaware(MaterialChooserField.create(label, isMandatory, pt.getMaterialType(), originalRawValue, viewContext));
            }
            case HYPERLINK: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new HyperlinkField(label, isMandatory), originalRawValue));
            }
            case MULTILINE_VARCHAR: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new MultilineVarcharField(label, isMandatory), originalRawValue));
            }
            case XML: {
                return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new XmlField(label, isMandatory), originalRawValue));
            }
        }
        throw new IllegalStateException("unknown enum " + dataType);
    }

    private static DatabaseModificationAwareField<?> createControlledVocabularyField(String fieldId, String label, Vocabulary vocabulary, boolean isMandatory, IViewContext<ICommonClientServiceAsync> viewContext, String originalRawValue) {
        if (vocabulary.isChosenFromList()) {
            return VocabularyTermSelectionWidget.create(fieldId, label, vocabulary, isMandatory, viewContext, originalRawValue);
        }
        return PropertyFieldFactory.wrapUnaware(PropertyFieldFactory.setValue(new VocabularyTermField(viewContext, label, isMandatory), originalRawValue));
    }

    private static DatabaseModificationAwareField<?> wrapUnaware(Field<?> field) {
        return DatabaseModificationAwareField.wrapUnaware(field);
    }

    public static final String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return DateRenderer.renderDate((Date)value);
        }
        if (value instanceof VocabularyTermModel) {
            VocabularyTerm term = ((VocabularyTermModel)value).getTerm();
            return term.getCode();
        }
        return value.toString();
    }

    private static <T> Field<T> setValue(Field<T> field, String originalRawValue) {
        if (originalRawValue != null) {
            field.setValue(field.getPropertyEditor().convertStringValue(originalRawValue));
        }
        return field;
    }
}

