/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListener;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.google.gwt.dom.client.NativeEvent;
import java.util.HashMap;
import java.util.Map;

public final class ColumnListener<T, M extends BaseEntityModel<T>>
implements Listener<GridEvent<?>> {
    private final Map<String, ICellListener<T>> linkListeners = new HashMap<String, ICellListener<T>>();
    private final Grid<M> grid;
    private static String LINK_TAG_NAME = "A";

    public ColumnListener(Grid<M> grid) {
        this.grid = grid;
        grid.addListener(Events.CellClick, (Listener)this);
    }

    public void registerLinkClickListener(String columnID, ICellListener<T> listener) {
        this.linkListeners.put(columnID.toLowerCase(), listener);
    }

    public void handleEvent(GridEvent<?> be) {
        ICellListener listener = this.getCellListener(be);
        if (listener != null) {
            ListStore store = be.getGrid().getStore();
            listener.handle(((BaseEntityModel)store.getAt(be.getRowIndex())).getBaseObject(), WidgetUtils.ifSpecialKeyPressed((NativeEvent)be.getEvent()));
        }
    }

    private ICellListener<T> getCellListener(GridEvent<?> event) {
        String columnID = this.grid.getColumnModel().getColumn(event.getColIndex()).getId().toLowerCase();
        return ColumnListener.isLinkTarget(event) ? this.linkListeners.get(columnID) : null;
    }

    public static boolean isLinkTarget(GridEvent<?> event) {
        return event.getTarget() != null && event.getTarget().getTagName().equals(LINK_TAG_NAME);
    }
}

