/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.column;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.AbstractColumnSettingsDataModelProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.expressions.common.AbstractGridCustomExpressionEditOrRegisterDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.GridRowModels;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.GridRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExpression;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GridCustomColumn;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewColumnOrFilter;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class GridCustomColumnGrid
extends TypedTableGrid<GridCustomColumn> {
    private static final String BROWSER_ID = "openbis_custom-grid-column-browser";
    protected final String gridDisplayId;
    private final AbstractColumnSettingsDataModelProvider columnDataModelProvider;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, String gridDisplayId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        return new GridCustomColumnGrid(viewContext, gridDisplayId, columnDataModelProvider).asDisposableWithoutToolbar();
    }

    static final String createAddButtonId(String gridDisplayId) {
        return String.valueOf(GridCustomColumnGrid.createGridId(gridDisplayId)) + "_ADD_BUTTON";
    }

    static final String createGridId(String gridDisplayId) {
        return String.valueOf(GridCustomColumnGrid.createBrowserId(gridDisplayId)) + "-grid";
    }

    private static final String createBrowserId(String gridDisplayId) {
        return BROWSER_ID + (gridDisplayId != null ? "_" + gridDisplayId : "");
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", this.viewContext.getMessage("column", new Object[0])), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                GridCustomColumnGrid.this.createAddDialog().show();
            }
        });
        addButton.setId(GridCustomColumnGrid.createAddButtonId(this.gridDisplayId));
        this.addButton(addButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<GridCustomColumn>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<GridCustomColumn>> selectedItem, boolean keyPressed) {
                GridCustomColumn selected = selectedItem.getBaseObject().getObjectOrNull();
                GridCustomColumnGrid.this.createEditDialog(selected).show();
            }
        });
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<GridCustomColumn>> selected, IBrowserGridActionInvoker invoker) {
                return new DeletionConfirmationDialog(GridCustomColumnGrid.this.viewContext, selected, GridCustomColumnGrid.this.createRefreshCallback(invoker));
            }
        });
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private Window createAddDialog() {
        return new AddDialog(this.viewContext, this.createRefreshGridAction(), this.gridDisplayId, this.columnDataModelProvider);
    }

    private Window createEditDialog(AbstractExpression updatedItem) {
        return new EditDialog((IViewContext<ICommonClientServiceAsync>)this.viewContext, this.createRefreshGridAction(), this.gridDisplayId, this.columnDataModelProvider, updatedItem);
    }

    private GridCustomColumnGrid(IViewContext<ICommonClientServiceAsync> viewContext, String gridDisplayId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
        super(viewContext, GridCustomColumnGrid.createBrowserId(gridDisplayId), true, DisplayTypeIDGenerator.CUSTOM_GRID_COLUMN_GRID);
        this.gridDisplayId = gridDisplayId;
        this.columnDataModelProvider = columnDataModelProvider;
        this.extendBottomToolbar();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<GridCustomColumn>> resultSetConfig, final AbstractAsyncCallback<TypedTableResultSet<GridCustomColumn>> callback) {
        final int orgOffset = resultSetConfig.getOffset();
        final int orgLimit = resultSetConfig.getLimit();
        resultSetConfig.setOffset(0);
        resultSetConfig.setLimit(-1);
        AsyncCallback<TypedTableResultSet<GridCustomColumn>> wrappedCallback = new AsyncCallback<TypedTableResultSet<GridCustomColumn>>(){

            public void onSuccess(TypedTableResultSet<GridCustomColumn> result) {
                List<TableModelRowWithObject<GridCustomColumn>> allCustomColumns = result.getResultSet().getList().extractOriginalObjects();
                ArrayList<GridCustomColumn> columns = new ArrayList<GridCustomColumn>();
                for (TableModelRowWithObject<GridCustomColumn> row : allCustomColumns) {
                    columns.add(row.getObjectOrNull());
                }
                GridCustomColumnGrid.this.columnDataModelProvider.refreshCustomColumns(columns);
                this.setPageFromAllFetched(result, orgOffset, orgLimit);
                callback.onSuccess(result);
            }

            private void setPageFromAllFetched(TypedTableResultSet<GridCustomColumn> result, int offset, int limit) {
                GridRowModels<TableModelRowWithObject<GridCustomColumn>> allModel = result.getResultSet().getList();
                ArrayList pageResult = new ArrayList(limit);
                int i = offset;
                while (i < Math.min(offset + limit, allModel.size())) {
                    pageResult.add((GridRowModel)allModel.get(i));
                    ++i;
                }
                result.getResultSet().setList(allModel.cloneWithData(pageResult));
            }

            public void onFailure(Throwable caught) {
                callback.onFailure(caught);
            }
        };
        ((ICommonClientServiceAsync)this.viewContext.getService()).listGridCustomColumns(this.gridDisplayId, resultSetConfig, wrappedCallback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<GridCustomColumn>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportColumns(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("NAME", "IS_PUBLIC");
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<GridCustomColumn>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<GridCustomColumn>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("EXPRESSION", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.GRID_CUSTOM_COLUMN), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.GRID_CUSTOM_COLUMN)};
    }

    private static class AddDialog
    extends AbstractGridCustomExpressionEditOrRegisterDialog {
        private final IViewContext<ICommonClientServiceAsync> viewContext;

        public AddDialog(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedAction postRegistrationCallback, String gridId, AbstractColumnSettingsDataModelProvider columnDataModelProvider) {
            super(viewContext, viewContext.getMessage("add_new_column", new Object[0]), postRegistrationCallback, gridId, columnDataModelProvider);
            this.viewContext = viewContext;
        }

        @Override
        protected void register(AsyncCallback<Void> registrationCallback) {
            NewColumnOrFilter newItem = this.getNewItemInfo();
            this.viewContext.getService().registerColumn(newItem, registrationCallback);
        }

        @Override
        protected HelpPageIdentifier createHelpPageIdentifier() {
            return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.CUSTOM_COLUMN, HelpPageIdentifier.HelpPageAction.REGISTER);
        }
    }

    private static class DeletionConfirmationDialog
    extends AbstractDataConfirmationDialog<List<TableModelRowWithObject<GridCustomColumn>>> {
        private static final int LABEL_WIDTH = 60;
        private static final int FIELD_WIDTH = 180;
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final AbstractAsyncCallback<Void> callback;

        public DeletionConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, List<TableModelRowWithObject<GridCustomColumn>> data, AbstractAsyncCallback<Void> callback) {
            super(viewContext, data, viewContext.getMessage("delete_confirmation_title", new Object[0]));
            this.callback = callback;
            this.viewContext = viewContext;
        }

        @Override
        protected void extendForm() {
            this.formPanel.setLabelWidth(60);
            this.formPanel.setFieldWidth(180);
        }

        @Override
        protected String createMessage() {
            return "Do you really want to delete selected (" + ((List)this.data).size() + ") column(s)?";
        }

        @Override
        protected void executeConfirmedAction() {
            this.viewContext.getCommonService().deleteColumns(TechId.createList((Collection)this.data), this.callback);
        }
    }

    private static class EditDialog
    extends AbstractGridCustomExpressionEditOrRegisterDialog {
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final AbstractExpression itemToUpdate;

        public EditDialog(IViewContext<ICommonClientServiceAsync> viewContext, IDelegatedAction postRegistrationCallback, String gridId, AbstractColumnSettingsDataModelProvider columnDataModelProvider, AbstractExpression itemToUpdate) {
            super(viewContext, viewContext.getMessage("edit_title", viewContext.getMessage("column", new Object[0]), itemToUpdate.getName()), postRegistrationCallback, gridId, columnDataModelProvider);
            this.viewContext = viewContext;
            this.itemToUpdate = itemToUpdate;
            this.initializeValues(itemToUpdate);
        }

        @Override
        protected void register(AsyncCallback<Void> registrationCallback) {
            this.update(this.itemToUpdate);
            this.viewContext.getService().updateColumn(this.itemToUpdate, registrationCallback);
        }

        @Override
        protected HelpPageIdentifier createHelpPageIdentifier() {
            return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.CUSTOM_COLUMN, HelpPageIdentifier.HelpPageAction.EDIT);
        }
    }
}

