/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ProjectViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener.OpenEntityDetailsTabAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.viewer.MetaprojectViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithPermId;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;

public class OpenEntityDetailsTabHelper {
    public static void open(IViewContext<?> viewContext, EntityKind entityKind, String permId, boolean keyPressed) {
        viewContext.getCommonService().getEntityInformationHolder(entityKind, permId, new OpenEntityDetailsTabCallback(viewContext, keyPressed));
    }

    public static void open(IViewContext<?> viewContext, BasicEntityDescription description, boolean keyPressed) {
        viewContext.getCommonService().getEntityInformationHolder(description, new OpenEntityDetailsTabCallback(viewContext, keyPressed));
    }

    public static void open(IViewContext<?> viewContext, MaterialIdentifier identifier, boolean keyPressed) throws UserFailureException {
        viewContext.getCommonService().getMaterialInformationHolder(identifier, new OpenEntityDetailsTabCallback(viewContext, keyPressed));
    }

    public static void open(final IViewContext<?> viewContext, final Project project, boolean keyPressed, final String permlinkOrNull) {
        final TechId projectId = TechId.create(project);
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent viewer = ProjectViewer.create(viewContext.getCommonViewContext(), projectId);
                return DefaultTabItem.create(this.getTabTitle(), viewer, viewContext, false);
            }

            @Override
            public String getId() {
                return ProjectViewer.createId(projectId);
            }

            @Override
            public String getTabTitle() {
                return AbstractViewer.getTitle(viewContext, "project", project);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROJECT, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String tryGetLink() {
                return permlinkOrNull;
            }
        };
        tabFactory.setInBackground(keyPressed);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    public static void openMetaproject(final IViewContext<?> viewContext, final IIdAndCodeHolder metaproject, boolean keyPressed) {
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent viewer = MetaprojectViewer.create(viewContext, metaproject.getId());
                return DefaultTabItem.create(this.getTabTitle(), viewer, viewContext, false);
            }

            @Override
            public String getId() {
                return MetaprojectViewer.createId(metaproject.getId());
            }

            @Override
            public String getTabTitle() {
                return AbstractViewer.getTitle(viewContext, "metaproject", metaproject);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.METAPROJECT, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.createMetaprojectLink(metaproject.getCode());
            }
        };
        tabFactory.setInBackground(keyPressed);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    private static class OpenEntityDetailsTabCallback
    extends AbstractAsyncCallback<IEntityInformationHolderWithPermId> {
        private final boolean keyPressed;

        private OpenEntityDetailsTabCallback(IViewContext<?> viewContext, boolean keyPressed) {
            super(viewContext);
            this.keyPressed = keyPressed;
        }

        private OpenEntityDetailsTabCallback(IViewContext<?> viewContext) {
            this(viewContext, false);
        }

        @Override
        protected final void process(IEntityInformationHolderWithPermId result) {
            new OpenEntityDetailsTabAction(result, this.viewContext, this.keyPressed).execute();
        }
    }
}

