/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.listener;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPluginFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;

public final class OpenEntityEditorTabClickListener
implements ClickHandler {
    private final IEntityInformationHolder entity;
    private final IViewContext<?> viewContext;

    public OpenEntityEditorTabClickListener(IEntityInformationHolder entity, IViewContext<?> viewContext) {
        this.entity = entity;
        this.viewContext = viewContext;
    }

    public void onClick(ClickEvent event) {
        OpenEntityEditorTabClickListener.showEntityEditor(this.viewContext, this.entity, WidgetUtils.ifSpecialKeyPressed(event.getNativeEvent()));
    }

    public static void showEntityEditor(IViewContext<?> viewContext, IEntityInformationHolder entity, boolean inBackground) {
        assert (entity != null) : "entity is not provided";
        if (OpenEntityEditorTabClickListener.forbidDeletedEntityModification(viewContext, entity)) {
            return;
        }
        BasicEntityType entityType = entity.getEntityType();
        EntityKind entityKind = entity.getEntityKind();
        IClientPluginFactory clientPluginFactory = viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, entityType);
        IClientPlugin createClientPlugin = clientPluginFactory.createClientPlugin(entityKind);
        AbstractTabItemFactory tabView = createClientPlugin.createEntityEditor(entity);
        tabView.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabView);
    }

    public static boolean forbidDeletedEntityModification(IMessageProvider messageProvider, IEntityInformationHolder entity) {
        if (DeletionUtils.isDeleted(entity)) {
            String title = messageProvider.getMessage("cannot_modify_deleted_entity_title", entity.getEntityKind().getDescription());
            String msg = messageProvider.getMessage("cannot_modify_deleted_entity_msg", entity.getEntityKind().getDescription(), entity.getCode());
            MessageBox.alert((String)title, (String)msg, null);
            return true;
        }
        return false;
    }
}

