/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.managed_property;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedComboBoxInputWidgetDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedInputWidgetDescription;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboBox;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import java.util.List;
import java.util.Map;

public class ManagedPropertyFormHelper {
    private final IViewContext<?> viewContext;
    private final FormPanel formPanel;
    private final Map<String, TextField<?>> inputFieldsByCode;

    public ManagedPropertyFormHelper(IViewContext<?> viewContext, FormPanel formPanel, Map<String, TextField<?>> inputFieldsByCode) {
        this.viewContext = viewContext;
        this.formPanel = formPanel;
        this.inputFieldsByCode = inputFieldsByCode;
    }

    public void fillForm(List<IManagedInputWidgetDescription> inputWidgetDescriptions) {
        for (IManagedInputWidgetDescription inputDescription : inputWidgetDescriptions) {
            TextField<?> field;
            this.trySetBoundedValue(inputDescription);
            switch (inputDescription.getManagedInputFieldType()) {
                case TEXT: {
                    field = this.createTextField(inputDescription);
                    break;
                }
                case MULTILINE_TEXT: {
                    field = this.createMultilineTextField(inputDescription);
                    break;
                }
                case COMBO_BOX: {
                    field = this.createComboBoxField(inputDescription);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            String label = inputDescription.getLabel();
            if (label == null) {
                this.throwFailToCreateContentException("Label is not set in input widget description");
            }
            field.setFieldLabel(label);
            if (inputDescription.getDescription() != null) {
                AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
                FieldUtil.addInfoIcon(field, inputDescription.getDescription(), infoIcon.createImage());
            }
            FieldUtil.setMandatoryFlag(field, inputDescription.isMandatory());
            this.inputFieldsByCode.put(inputDescription.getCode(), field);
            this.formPanel.add(field);
        }
    }

    protected void trySetBoundedValue(IManagedInputWidgetDescription inputDescription) {
    }

    private TextField<?> createTextField(IManagedInputWidgetDescription inputDescription) {
        TextField field = new TextField();
        if (inputDescription.getValue() != null) {
            FieldUtil.setValueWithUnescaping((Field<String>)field, inputDescription.getValue());
            field.updateOriginalValue((Object)((String)field.getValue()));
        }
        return field;
    }

    private TextField<?> createMultilineTextField(IManagedInputWidgetDescription inputDescription) {
        MultilineVarcharField field = new MultilineVarcharField(inputDescription.getLabel(), false);
        if (inputDescription.getValue() != null) {
            FieldUtil.setValueWithUnescaping((Field<String>)field, inputDescription.getValue());
            field.updateOriginalValue((String)field.getValue());
        }
        return field;
    }

    private TextField<?> createComboBoxField(IManagedInputWidgetDescription inputDescription) {
        SimpleComboBox comboBox = new SimpleComboBox();
        comboBox.setTriggerAction(ComboBox.TriggerAction.ALL);
        comboBox.setEditable(false);
        comboBox.setForceSelection(true);
        if (inputDescription instanceof ManagedComboBoxInputWidgetDescription) {
            ManagedComboBoxInputWidgetDescription comboBoxDescription = (ManagedComboBoxInputWidgetDescription)inputDescription;
            comboBox.add(comboBoxDescription.getOptions());
            if (inputDescription.getValue() != null) {
                comboBox.setSimpleValue((Object)inputDescription.getValue());
                comboBox.updateOriginalValue((Object)((SimpleComboValue)comboBox.getValue()));
            }
            return comboBox;
        }
        this.throwFailToCreateContentException("'" + inputDescription.getLabel() + "' description should be a subclass of ManagedComboBoxInputWidgetDescription");
        return null;
    }

    private void throwFailToCreateContentException(String detailedErrorMsg) throws UserFailureException {
        throw new UserFailureException("Failed to create content.", detailedErrorMsg);
    }
}

