/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.MaterialTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import java.util.List;

public final class MaterialTypeSelectionWidget
extends DropDownList<MaterialTypeModel, MaterialType> {
    public static final String SUFFIX = "material-type";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final String additionalOptionLabelOrNull;
    private final String initialCodeOrNull;
    private final boolean withTypeInFile;

    public static MaterialTypeSelectionWidget createWithAdditionalOption(IViewContext<ICommonClientServiceAsync> viewContext, String additionalOptionLabel, String initialCodeOrNullParameter, String idSuffix) {
        return new MaterialTypeSelectionWidget(viewContext, additionalOptionLabel, idSuffix, initialCodeOrNullParameter, null, false);
    }

    public static MaterialTypeSelectionWidget create(IViewContext<ICommonClientServiceAsync> viewContext, String displayTypeIdOrNull, String initialCodeOrNullParameter, String idSuffix) {
        return new MaterialTypeSelectionWidget(viewContext, null, idSuffix, initialCodeOrNullParameter, displayTypeIdOrNull, false);
    }

    public MaterialTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String initialCodeOrNullParameter, String idSuffix, boolean withTypeInFile) {
        this(viewContext, null, idSuffix, initialCodeOrNullParameter, null, withTypeInFile);
    }

    private MaterialTypeSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String additionalOptionLabelOrNull, String idSuffix, String initialCodeOrNullParameter, final String displayTypeIdOrNull, boolean withTypeInFile) {
        super(viewContext, SUFFIX + idSuffix, "material_type", "code", "material type", "material types");
        this.viewContext = viewContext;
        this.additionalOptionLabelOrNull = additionalOptionLabelOrNull;
        this.initialCodeOrNull = MaterialTypeSelectionWidget.tryGetInitialValue(displayTypeIdOrNull, initialCodeOrNullParameter, viewContext.getDisplaySettingsManager());
        this.withTypeInFile = withTypeInFile;
        this.setAutoSelectFirst(additionalOptionLabelOrNull != null && this.initialCodeOrNull == null);
        this.setTemplate(GWTUtils.getTooltipTemplate("code", "tooltip"));
        if (displayTypeIdOrNull != null) {
            final DisplaySettingsManager displaySettingsManager = viewContext.getDisplaySettingsManager();
            this.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<MaterialTypeModel>(){

                public void selectionChanged(SelectionChangedEvent<MaterialTypeModel> se) {
                    MaterialTypeSelectionWidget.this.saveSelectedValueAsDisplaySetting(displaySettingsManager, displayTypeIdOrNull);
                }
            });
        }
    }

    private void saveSelectedValueAsDisplaySetting(DisplaySettingsManager displaySettingsManager, String dropDownId) {
        MaterialType selectedOrNull = (MaterialType)this.tryGetSelected();
        if (selectedOrNull != null) {
            displaySettingsManager.storeDropDownSettings(dropDownId, selectedOrNull.getCode());
        }
    }

    public final MaterialType tryGetSelectedMaterialType() {
        return (MaterialType)super.tryGetSelected();
    }

    public final boolean isAdditionalOptionSelected() {
        return this.includeAdditionalOption() && this.isAnythingSelected() && this.tryGetSelected() == null;
    }

    @Override
    protected List<MaterialTypeModel> convertItems(List<MaterialType> result) {
        if (this.includeAdditionalOption()) {
            return MaterialTypeModel.convertWithAdditionalOption(result, this.additionalOptionLabelOrNull, this.withTypeInFile);
        }
        return MaterialTypeModel.convert(result, this.withTypeInFile);
    }

    private boolean includeAdditionalOption() {
        return this.additionalOptionLabelOrNull != null;
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<MaterialType>> callback) {
        this.viewContext.getService().listMaterialTypes(new ListMaterialTypesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.MATERIAL_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.MATERIAL_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    private void selectInitialValue() {
        if (this.initialCodeOrNull != null) {
            this.trySelectByPropertyValue("code", this.initialCodeOrNull, "Material Type '" + this.initialCodeOrNull + "' doesn't exist.");
            this.updateOriginalValue();
        }
    }

    private static String tryGetInitialValue(String displayTypeIdOrNull, String initialCodeOrNull, DisplaySettingsManager displaySettingsManager) {
        boolean initialCodeExplicitlyDefined;
        boolean bl = initialCodeExplicitlyDefined = initialCodeOrNull != null;
        if (initialCodeExplicitlyDefined) {
            return initialCodeOrNull;
        }
        if (displayTypeIdOrNull != null) {
            return displaySettingsManager.getDropDownSettings(displayTypeIdOrNull);
        }
        return null;
    }

    private class ListMaterialTypesCallback
    extends DropDownList.ListItemsCallback {
        protected ListMaterialTypesCallback(IViewContext<?> viewContext) {
            super(MaterialTypeSelectionWidget.this, viewContext);
        }

        @Override
        public void process(List<MaterialType> result) {
            super.process(result);
            MaterialTypeSelectionWidget.this.selectInitialValue();
        }
    }
}

