/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.browser;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableComposite;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.browser.MetaprojectBrowserTreePanel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.entity.MetaprojectEntities;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.MetaprojectTree;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeEntityItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeEntityKindItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.tree.model.MetaprojectTreeMetaprojectItemData;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.BorderLayoutHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.Set;

public class MetaprojectBrowser
extends ContentPanel
implements IDisposableComponent {
    public static final String ID = "openbis_metaproject-browser";
    public static final String DISPLAY_ID_SUFFIX = "metaproject-browser";
    private IViewContext<?> viewContext;
    private MetaprojectTree tree;
    private MetaprojectBrowserTreePanel treePanel;
    private SelectionChangedListener<MetaprojectTreeItemData> treeListener;
    private MetaprojectEntities entities;
    private DisposableComposite composite = new DisposableComposite((Component)this);

    public MetaprojectBrowser(IViewContext<?> viewContext) {
        this.setId(ID);
        this.setLayout((Layout)new BorderLayout());
        this.setHeaderVisible(false);
        this.viewContext = viewContext;
        this.tree = new MetaprojectTree(viewContext, this.getId());
        this.treeListener = new SelectionChangedListener<MetaprojectTreeItemData>(){

            public void selectionChanged(SelectionChangedEvent<MetaprojectTreeItemData> se) {
                MetaprojectBrowser.this.showEntities((MetaprojectTreeItemData)se.getSelectedItem());
            }
        };
        this.tree.getSelectionModel().addSelectionChangedListener(this.treeListener);
        this.entities = new MetaprojectEntities(viewContext, this.getId());
        this.entities.addListener(MetaprojectEntities.ENTITIES_CHANGED, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                MetaprojectBrowser.this.refresh();
            }
        });
        this.composite.addSubcomponent(this.tree);
        this.composite.addSubcomponent(this.entities);
        BorderLayoutData treeLayout = this.getHelper().createLeftBorderLayoutData();
        BorderLayoutData gridsLayout = BorderLayoutHelper.createRightBorderLayoutData();
        this.treePanel = new MetaprojectBrowserTreePanel(viewContext, this.tree);
        this.add((Widget)this.treePanel, (LayoutData)treeLayout);
        this.add((Widget)this.entities, (LayoutData)gridsLayout);
        this.layout();
    }

    protected void onAttach() {
        super.onAttach();
        this.getHelper().configureLeftPanel((Component)this.treePanel);
    }

    private void showEntities(MetaprojectTreeItemData item) {
        if (item == null) {
            this.entities.hideEntities();
        } else if (item instanceof MetaprojectTreeMetaprojectItemData) {
            MetaprojectTreeMetaprojectItemData metaprojectItem = (MetaprojectTreeMetaprojectItemData)item;
            this.entities.showEntities(metaprojectItem.getMetaproject().getId(), IDelegatedAction.DO_NOTHING);
        } else if (item instanceof MetaprojectTreeEntityKindItemData) {
            MetaprojectTreeEntityKindItemData entityKindItem = (MetaprojectTreeEntityKindItemData)item;
            this.entities.showEntities(entityKindItem.getMetaprojectId(), entityKindItem.getEntityKind(), IDelegatedAction.DO_NOTHING);
        } else if (item instanceof MetaprojectTreeEntityItemData) {
            MetaprojectTreeEntityItemData entityItem = (MetaprojectTreeEntityItemData)item;
            this.entities.showEntities(entityItem.getMetaprojectId(), entityItem.getEntity().getEntityKind(), IDelegatedAction.DO_NOTHING);
        }
    }

    public void refresh() {
        this.showEntities(null);
        this.tree.getSelectionModel().removeSelectionListener(this.treeListener);
        this.tree.refresh(new IDelegatedAction(){

            @Override
            public void execute() {
                MetaprojectBrowser.this.showEntities((MetaprojectTreeItemData)MetaprojectBrowser.this.tree.getSelectionModel().getSelectedItem());
                MetaprojectBrowser.this.tree.getSelectionModel().addSelectionChangedListener(MetaprojectBrowser.this.treeListener);
            }
        });
    }

    private BorderLayoutHelper getHelper() {
        return new BorderLayoutHelper(this.viewContext, (BorderLayout)this.getLayout(), DISPLAY_ID_SUFFIX);
    }

    @Override
    public Component getComponent() {
        return this.composite.getComponent();
    }

    @Override
    public void dispose() {
        this.composite.dispose();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return this.composite.getRelevantModifications();
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.refresh();
    }
}

