/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.metaproject.viewer;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property.PropertyGrid;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectAssignmentsCount;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class MetaprojectPropertiesPanel
extends ContentPanel
implements IDisposableComponent {
    public static final String PROPERTIES_ID_PREFIX = "openbis_metaproject-properties-section_";
    private IViewContext<?> viewContext;
    private Long metaprojectId;
    private PropertyGrid propertyGrid;

    public MetaprojectPropertiesPanel(IViewContext<?> viewContext, Long metaprojectId) {
        super((Layout)new BorderLayout());
        this.viewContext = viewContext;
        this.metaprojectId = metaprojectId;
        this.setHeading(viewContext.getMessage("metaproject_properties", new Object[0]));
        this.load();
    }

    private void load() {
        this.viewContext.getCommonService().getMetaprojectAssignmentsCount(this.metaprojectId, (AsyncCallback<MetaprojectAssignmentsCount>)new AbstractAsyncCallback<MetaprojectAssignmentsCount>(this.viewContext){

            @Override
            protected void process(MetaprojectAssignmentsCount count) {
                Map properties = MetaprojectPropertiesPanel.this.createProperties(count);
                if (MetaprojectPropertiesPanel.this.propertyGrid == null) {
                    MetaprojectPropertiesPanel.this.createPropertyGrid(properties);
                } else {
                    MetaprojectPropertiesPanel.this.updatePropertyGrid(properties);
                }
            }
        });
    }

    private Map<String, Object> createProperties(MetaprojectAssignmentsCount count) {
        Metaproject metaproject = count.getMetaproject();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.put(this.viewContext.getMessage("metaproject", new Object[0]), metaproject.getIdentifier());
        properties.put(this.viewContext.getMessage("name", new Object[0]), metaproject.getName());
        properties.put(this.viewContext.getMessage("description", new Object[0]), metaproject.getDescription());
        if (count.getExperimentCount() > 0) {
            properties.put(this.viewContext.getMessage("metaproject_entities_experiments", new Object[0]), count.getExperimentCount());
        }
        if (count.getSampleCount() > 0) {
            properties.put(this.viewContext.getMessage("metaproject_entities_samples", new Object[0]), count.getSampleCount());
        }
        if (count.getDataSetCount() > 0) {
            properties.put(this.viewContext.getMessage("metaproject_entities_data_sets", new Object[0]), count.getDataSetCount());
        }
        if (count.getMaterialCount() > 0) {
            properties.put(this.viewContext.getMessage("metaproject_entities_materials", new Object[0]), count.getMaterialCount());
        }
        properties.put(this.viewContext.getMessage("creation_date", new Object[0]), metaproject.getCreationDate());
        return properties;
    }

    private void createPropertyGrid(Map<String, Object> properties) {
        this.propertyGrid = new PropertyGrid(this.viewContext, properties.size());
        this.propertyGrid.getElement().setId(PROPERTIES_ID_PREFIX + this.metaprojectId);
        this.propertyGrid.setProperties(properties);
        ContentPanel panel = new ContentPanel();
        panel.setHeaderVisible(false);
        panel.setScrollMode(Style.Scroll.AUTOY);
        panel.add((Widget)this.propertyGrid);
        this.add((Widget)panel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        this.layout();
    }

    private void updatePropertyGrid(Map<String, Object> properties) {
        this.propertyGrid.resizeRows(properties.size());
        this.propertyGrid.setProperties(properties);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        HashSet<DatabaseModificationKind> result = new HashSet<DatabaseModificationKind>();
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.METAPROJECT);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.EXPERIMENT);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.SAMPLE);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.DATA_SET);
        DatabaseModificationKind.addAny(result, DatabaseModificationKind.ObjectKind.MATERIAL);
        return result.toArray(DatabaseModificationKind.EMPTY_ARRAY);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.load();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
    }
}

