/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ProjectViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractViewer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.columns.framework.LinkExtractor;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.AbstractProjectEditRegisterForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.ProjectEditForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.project.ProjectListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProjectGrid
extends TypedTableGrid<Project> {
    public static final String BROWSER_ID = "openbis_project-browser";
    public static final String GRID_ID = "openbis_project-browser-grid";
    public static final String SHOW_DETAILS_BUTTON_ID = "openbis_project-browser-show-details";
    public static final String EDIT_BUTTON_ID = "openbis_project-browser-edit";
    public static final String DELETE_BUTTON_ID = "openbis_project-browser-delete";

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        ProjectGrid grid = new ProjectGrid(viewContext);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private ProjectGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.PROJECT_BROWSER_GRID);
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", "Project"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DispatcherHelper.dispatchNaviEvent(new ComponentProvider(ProjectGrid.this.viewContext).getProjectRegistration());
            }
        });
        this.addButton(addButton);
        Button showDetailsButton = this.createSelectedItemButton(this.viewContext.getMessage("button_show_details", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<Project>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<Project>> selectedItem, boolean keyPressed) {
                ProjectGrid.this.showEntityViewer(selectedItem.getBaseObject(), false, keyPressed);
            }
        });
        showDetailsButton.setId(SHOW_DETAILS_BUTTON_ID);
        this.addButton(showDetailsButton);
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<Project>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<Project>> selectedItem, boolean keyPressed) {
                ProjectGrid.this.showEntityViewer(selectedItem.getBaseObject(), true, keyPressed);
            }
        });
        editButton.setId(EDIT_BUTTON_ID);
        this.addButton(editButton);
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<Project>> rows, IBrowserGridActionInvoker invoker) {
                ArrayList<Project> projects = new ArrayList<Project>();
                for (TableModelRowWithObject<Project> row : rows) {
                    projects.add(row.getObjectOrNull());
                }
                return new ProjectListDeletionConfirmationDialog((IViewContext<ICommonClientServiceAsync>)ProjectGrid.this.viewContext, (List<Project>)projects, (AbstractAsyncCallback<Void>)ProjectGrid.this.createRefreshCallback(invoker));
            }
        });
        deleteButton.setId(DELETE_BUTTON_ID);
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Project>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Project>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("CODE", this.createInternalLinkCellRenderer());
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        schema.setGridCellRendererFor("MODIFIER", PersonRenderer.MODIFIER_RENDERER);
        return schema;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Project>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Project>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listProjects(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Project>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportProjects(exportCriteria, callback);
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE", "SPACE");
    }

    @Override
    protected void showEntityViewer(TableModelRowWithObject<Project> row, boolean editMode, boolean inBackground) {
        ProjectGrid.showEntityViewer(row.getObjectOrNull(), editMode, this.viewContext, inBackground);
    }

    public static void showEntityViewer(final Project project, boolean editMode, final IViewContext<ICommonClientServiceAsync> viewContext, boolean inBackground) {
        final TechId projectId = TechId.create(project);
        AbstractTabItemFactory tabFactory = !editMode ? new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent viewer = ProjectViewer.create(viewContext, projectId);
                return DefaultTabItem.create(this.getTabTitle(), viewer, viewContext, false);
            }

            @Override
            public String getId() {
                return ProjectViewer.createId(projectId);
            }

            @Override
            public String getTabTitle() {
                return AbstractViewer.getTitle(viewContext, "project", project);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROJECT, HelpPageIdentifier.HelpPageAction.VIEW);
            }

            @Override
            public String tryGetLink() {
                return LinkExtractor.tryExtract(project);
            }
        } : new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                DatabaseModificationAwareComponent component = ProjectEditForm.create(viewContext, projectId);
                return DefaultTabItem.create(this.getTabTitle(), component, viewContext, true);
            }

            @Override
            public String getId() {
                return AbstractProjectEditRegisterForm.createId(projectId);
            }

            @Override
            public String getTabTitle() {
                return AbstractRegistrationForm.getEditTitle(viewContext, "project", project);
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.PROJECT, HelpPageIdentifier.HelpPageAction.EDIT);
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tabFactory.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROJECT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROJECT)};
    }
}

