/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.CompositeDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DataTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.XmlField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.material.MaterialTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.DataTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularySelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;

public final class PropertyTypeRegistrationForm
extends AbstractRegistrationForm {
    public static final String ID = "openbis_property-type-registration_form";
    private final CodeField propertyTypeCodeField;
    private final VarcharField propertyTypeLabelField;
    private final MultilineVarcharField propertyTypeDescriptionField;
    private final DataTypeSelectionWidget dataTypeSelectionWidget;
    private final VocabularySelectionWidget vocabularySelectionWidget;
    private final MaterialTypeSelectionWidget materialTypeSelectionWidget;
    private final XmlField xmlSchemaField;
    private final XmlField xslTransformationsField;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        PropertyTypeRegistrationForm form = new PropertyTypeRegistrationForm(viewContext);
        IDatabaseModificationObserver observer = form.createDatabaseModificationObserver();
        return new DatabaseModificationAwareComponent((Component)form, observer);
    }

    private PropertyTypeRegistrationForm(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, ID, 120, 500);
        this.setResetButtonVisible(true);
        this.viewContext = viewContext;
        this.propertyTypeCodeField = this.createPropertyTypeCodeField();
        this.propertyTypeLabelField = this.createPropertyTypeLabelField();
        this.propertyTypeDescriptionField = this.createPropertyTypeDescriptionField();
        this.dataTypeSelectionWidget = this.createDataTypeSelectionWidget();
        this.vocabularySelectionWidget = this.createVocabularySelectionWidget();
        this.materialTypeSelectionWidget = this.createMaterialTypeSelectionField();
        this.xmlSchemaField = this.createXmlSchemaField();
        this.xslTransformationsField = this.createXslTransformationsField();
        this.vocabularySelectionWidget.setVisible(false);
        this.materialTypeSelectionWidget.setVisible(false);
        this.xmlSchemaField.setVisible(false);
        this.xslTransformationsField.setVisible(false);
        this.formPanel.add((Widget)this.propertyTypeCodeField);
        this.formPanel.add((Widget)this.propertyTypeLabelField);
        this.formPanel.add((Widget)this.propertyTypeDescriptionField);
        this.formPanel.add((Widget)this.dataTypeSelectionWidget);
        this.formPanel.add((Widget)this.vocabularySelectionWidget);
        this.formPanel.add((Widget)this.materialTypeSelectionWidget);
        this.formPanel.add((Widget)this.xmlSchemaField);
        this.formPanel.add((Widget)this.xslTransformationsField);
    }

    private MaterialTypeSelectionWidget createMaterialTypeSelectionField() {
        String label = this.viewContext.getMessage("allow_any_type", new Object[0]);
        MaterialTypeSelectionWidget chooser = MaterialTypeSelectionWidget.createWithAdditionalOption(this.viewContext, label, null, ID);
        FieldUtil.markAsMandatory(chooser);
        return chooser;
    }

    private final CodeField createPropertyTypeCodeField() {
        CodeField codeField = new CodeField(this.viewContext, this.viewContext.getMessage("code", new Object[0]));
        codeField.setId(String.valueOf(this.getId()) + "_code");
        return codeField;
    }

    private final VarcharField createPropertyTypeLabelField() {
        VarcharField varcharField = new VarcharField(this.viewContext.getMessage("label", new Object[0]), true);
        varcharField.setId(String.valueOf(this.getId()) + "_label");
        varcharField.setMaxLength(128);
        return varcharField;
    }

    private final MultilineVarcharField createPropertyTypeDescriptionField() {
        return new DescriptionField(this.viewContext, true, this.getId());
    }

    private final XmlField createXmlSchemaField() {
        String label = this.viewContext.getMessage("xml_schema", new Object[0]);
        String description = this.viewContext.getMessage("xml_schema_info", new Object[0]);
        AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
        XmlField field = new XmlField(label, false);
        FieldUtil.addInfoIcon(field, description, infoIcon.createImage());
        return field;
    }

    private final XmlField createXslTransformationsField() {
        String label = this.viewContext.getMessage("xslt", new Object[0]);
        String description = this.viewContext.getMessage("xslt_info", new Object[0]);
        AbstractImagePrototype infoIcon = AbstractImagePrototype.create((ImageResource)this.viewContext.getImageBundle().getInfoIcon());
        XmlField field = new XmlField(label, false);
        FieldUtil.addInfoIcon(field, description, infoIcon.createImage());
        return field;
    }

    private final DataTypeSelectionWidget createDataTypeSelectionWidget() {
        DataTypeSelectionWidget selectionWidget = new DataTypeSelectionWidget(this.viewContext, true);
        selectionWidget.addSelectionChangedListener(new DataTypeSelectionChangedListener());
        return selectionWidget;
    }

    private final VocabularySelectionWidget createVocabularySelectionWidget() {
        VocabularySelectionWidget result = new VocabularySelectionWidget(this.viewContext);
        FieldUtil.markAsMandatory(result);
        return result;
    }

    private final String getPropertyTypeCode() {
        return ((String)this.propertyTypeCodeField.getValue()).toUpperCase();
    }

    private final PropertyType createPropertyType() {
        PropertyType propertyType = new PropertyType();
        propertyType.setCode(this.getPropertyTypeCode());
        propertyType.setLabel((String)this.propertyTypeLabelField.getValue());
        propertyType.setDescription((String)this.propertyTypeDescriptionField.getValue());
        DataType selectedDataType = this.dataTypeSelectionWidget.tryGetSelectedDataType();
        propertyType.setDataType(selectedDataType);
        switch (selectedDataType.getCode()) {
            case MATERIAL: {
                propertyType.setMaterialType(this.tryGetSelectedMaterialTypeProperty());
                break;
            }
            case CONTROLLEDVOCABULARY: {
                propertyType.setVocabulary(this.tryGetSelectedVocabulary());
                break;
            }
            case XML: {
                propertyType.setSchema(this.tryGetXmlSchema());
                propertyType.setTransformation(this.tryGetXslTransformation());
                break;
            }
        }
        return propertyType;
    }

    private MaterialType tryGetSelectedMaterialTypeProperty() {
        return (MaterialType)this.materialTypeSelectionWidget.tryGetSelected();
    }

    private Vocabulary tryGetSelectedVocabulary() {
        return (Vocabulary)GWTUtils.tryGetSingleSelected(this.vocabularySelectionWidget);
    }

    private String tryGetXmlSchema() {
        return (String)this.xmlSchemaField.getValue();
    }

    private String tryGetXslTransformation() {
        return (String)this.xslTransformationsField.getValue();
    }

    @Override
    protected final void submitValidForm() {
        PropertyType propertyType = this.createPropertyType();
        this.viewContext.getService().registerPropertyType(propertyType, new PropertyTypeRegistrationCallback(this.viewContext, propertyType));
    }

    public IDatabaseModificationObserver createDatabaseModificationObserver() {
        CompositeDatabaseModificationObserver observer = new CompositeDatabaseModificationObserver();
        observer.addObserver(this.vocabularySelectionWidget);
        observer.addObserver(this.materialTypeSelectionWidget);
        return observer;
    }

    private final class DataTypeSelectionChangedListener
    extends SelectionChangedListener<DataTypeModel> {
        private DataTypeSelectionChangedListener() {
        }

        public final void selectionChanged(SelectionChangedEvent<DataTypeModel> se) {
            this.hideDataTypeRelatedFields();
            DataTypeModel selectedItem = (DataTypeModel)se.getSelectedItem();
            if (selectedItem != null) {
                DataTypeCode dataTypeCode = selectedItem.getDataType().getCode();
                switch (dataTypeCode) {
                    case CONTROLLEDVOCABULARY: {
                        this.showFields(new Field[]{PropertyTypeRegistrationForm.this.vocabularySelectionWidget});
                        break;
                    }
                    case MATERIAL: {
                        this.showFields(new Field[]{PropertyTypeRegistrationForm.this.materialTypeSelectionWidget});
                        break;
                    }
                    case XML: {
                        this.showFields(new Field[]{PropertyTypeRegistrationForm.this.xmlSchemaField, PropertyTypeRegistrationForm.this.xslTransformationsField});
                        break;
                    }
                }
            }
        }

        private void showFields(Field<?> ... fields) {
            FieldUtil.setVisibility(true, fields);
        }

        private void hideDataTypeRelatedFields() {
            FieldUtil.setVisibility(false, new Field[]{PropertyTypeRegistrationForm.this.vocabularySelectionWidget, PropertyTypeRegistrationForm.this.materialTypeSelectionWidget, PropertyTypeRegistrationForm.this.xmlSchemaField, PropertyTypeRegistrationForm.this.xslTransformationsField});
        }
    }

    private final class PropertyTypeRegistrationCallback
    extends AbstractRegistrationForm.AbstractRegistrationCallback<Void> {
        private final PropertyType propertyType;

        PropertyTypeRegistrationCallback(IViewContext<?> viewContext, PropertyType propertyType) {
            super(viewContext);
            this.propertyType = propertyType;
        }

        @Override
        protected String createSuccessfullRegistrationInfo(Void result) {
            return "Property type <b>" + this.propertyType.getCode() + "</b> successfully registered.";
        }
    }
}

