/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.report;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSetFetchConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableModelReference;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.IReportInformationProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportRowModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableGridColumnDefinition;
import java.util.HashSet;
import java.util.Set;

public class ReportGrid
extends TypedTableGrid<ReportRowModel> {
    public static final String BROWSER_ID = "openbis_DataSetReporterGrid";
    private final String resultSetKey;
    private final String displaySettingsId;
    private final TableModelReference tableModelReference;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext, TableModelReference tableModelReference, IReportInformationProvider infoProvider, String displaySettingsId) {
        ReportGrid grid = new ReportGrid(viewContext, tableModelReference, displaySettingsId, infoProvider.getDownloadURL());
        return grid.asDisposableWithoutToolbar();
    }

    public static String createId(String idSuffix) {
        return "openbis_DataSetReporterGrid_" + idSuffix;
    }

    private ReportGrid(IViewContext<ICommonClientServiceAsync> viewContext, TableModelReference tableModelReference, String displaySettingsId, String downloadURL) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.DATA_SET_REPORTING_GRID);
        this.setDownloadURL(downloadURL);
        this.setId(BROWSER_ID);
        this.tableModelReference = tableModelReference;
        this.resultSetKey = tableModelReference.getResultSetKey();
        this.displaySettingsId = displaySettingsId;
        this.updateDefaultRefreshButton();
    }

    @Override
    public String getGridDisplayTypeID() {
        return this.createGridDisplayTypeID(this.displaySettingsId);
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<ReportRowModel>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<ReportRowModel>> callback) {
        resultSetConfig.setCacheConfig(ResultSetFetchConfig.createFetchFromCacheAndRecompute(this.resultSetKey));
        HashSet availableColumns = new HashSet();
        if (this.tableModelReference.getHeader() != null) {
            for (TableModelColumnHeader header : this.tableModelReference.getHeader()) {
                availableColumns.add(new TypedTableGridColumnDefinition(header, null, null, null));
            }
        }
        resultSetConfig.setAvailableColumns(availableColumns);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listReport(resultSetConfig, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<ReportRowModel>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportReport(exportCriteria, callback);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }
}

