/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DatabaseModificationAwareComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SampleTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.plugin.IClientPlugin;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample.SampleTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.ui.Widget;

public final class SampleBatchRegisterUpdatePanel
extends LayoutContainer {
    private static final String ID_SUFFIX = "sample-batch-registration";
    private static final String ID = "openbis_sample-batch-registration";
    private final SampleTypeSelectionWidget sampleTypeSelection;
    private final IViewContext<ICommonClientServiceAsync> viewContext;

    public static String getId(boolean update) {
        return "openbis_sample-batch-registration_" + (update ? "update" : "registration");
    }

    public static DatabaseModificationAwareComponent create(IViewContext<ICommonClientServiceAsync> viewContext, boolean update) {
        SampleBatchRegisterUpdatePanel panel = new SampleBatchRegisterUpdatePanel(viewContext, update);
        return new DatabaseModificationAwareComponent((Component)panel, (IDatabaseModificationObserver)panel.sampleTypeSelection);
    }

    private SampleBatchRegisterUpdatePanel(final IViewContext<ICommonClientServiceAsync> viewContext, final boolean update) {
        this.viewContext = viewContext;
        this.setId(SampleBatchRegisterUpdatePanel.getId(update));
        this.setScrollMode(Style.Scroll.AUTO);
        this.sampleTypeSelection = new SampleTypeSelectionWidget(viewContext, ID_SUFFIX, false, false, true, null, this.createDisplayID(update));
        final ToolBar toolBar = this.createToolBar();
        this.add((Component)toolBar);
        this.sampleTypeSelection.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SampleTypeModel>(){

            public final void selectionChanged(SelectionChangedEvent<SampleTypeModel> se) {
                SampleType sampleType = SampleBatchRegisterUpdatePanel.this.sampleTypeSelection.tryGetSelectedSampleType();
                if (sampleType != null) {
                    SampleBatchRegisterUpdatePanel.this.removeAll();
                    EntityKind entityKind = EntityKind.SAMPLE;
                    SampleBatchRegisterUpdatePanel.this.add((Component)toolBar);
                    IClientPlugin createClientPlugin = viewContext.getClientPluginFactoryProvider().getClientPluginFactory(entityKind, sampleType).createClientPlugin(entityKind);
                    Widget batchOperationWidget = update ? createClientPlugin.createBatchUpdateForEntityType(sampleType) : createClientPlugin.createBatchRegistrationForEntityType(sampleType);
                    SampleBatchRegisterUpdatePanel.this.add(batchOperationWidget);
                    SampleBatchRegisterUpdatePanel.this.layout();
                }
            }
        });
    }

    private SampleTypeDisplayID createDisplayID(boolean update) {
        return update ? SampleTypeDisplayID.SAMPLE_BATCH_UPDATE : SampleTypeDisplayID.SAMPLE_BATCH_REGISTRATION;
    }

    private final ToolBar createToolBar() {
        ToolBar toolBar = new ToolBar();
        toolBar.add((Component)new LabelToolItem(String.valueOf(this.viewContext.getMessage("sample_type", new Object[0])) + ":"));
        toolBar.add((Component)this.sampleTypeSelection);
        return toolBar;
    }
}

