/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.sample;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplaySettingsManager;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.SampleTypeDisplayID;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.SampleTypeModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import java.util.Iterator;
import java.util.List;

public class SampleTypeSelectionWidget
extends DropDownList<SampleTypeModel, SampleType> {
    public static final String SUFFIX = "sample-type";
    private final IViewContext<?> viewContext;
    private final boolean onlyListable;
    private final boolean withAll;
    private final boolean withTypeInFile;
    private final String initialCodeOrNull;
    private String filterPattern;

    public SampleTypeSelectionWidget(IViewContext<?> viewContext, String idSuffix, boolean onlyListable, boolean withAll, boolean withTypeInFile, String initialCodeOrNullParameter, final SampleTypeDisplayID displayTypeID) {
        super(viewContext, SUFFIX + idSuffix, "sample_type", "code", "sample type", "sample types");
        this.viewContext = viewContext;
        this.onlyListable = onlyListable;
        this.withAll = withAll;
        this.withTypeInFile = withTypeInFile;
        this.initialCodeOrNull = SampleTypeSelectionWidget.tryGetInitialValue(displayTypeID, initialCodeOrNullParameter, viewContext.getDisplaySettingsManager());
        this.setAutoSelectFirst(withAll && this.initialCodeOrNull == null);
        this.setTemplate(GWTUtils.getTooltipTemplate("code", "tooltip"));
        final DisplaySettingsManager displaySettingsManager = viewContext.getDisplaySettingsManager();
        if (displayTypeID.isSavable()) {
            this.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SampleTypeModel>(){

                public void selectionChanged(SelectionChangedEvent<SampleTypeModel> se) {
                    SampleTypeSelectionWidget.this.saveSelectedValueAsDisplaySetting(displaySettingsManager, displayTypeID.createDisplayID());
                }
            });
        }
    }

    public SampleTypeSelectionWidget(IViewContext<?> viewContext, String idSuffix, boolean onlyListable, SampleTypeDisplayID displayTypeID, String initialCodeOrNullParameter) {
        this(viewContext, idSuffix, onlyListable, false, false, initialCodeOrNullParameter, displayTypeID);
    }

    private void saveSelectedValueAsDisplaySetting(DisplaySettingsManager displaySettingsManager, String dropDownID) {
        SampleType selectedOrNull = (SampleType)this.tryGetSelected();
        if (selectedOrNull != null) {
            displaySettingsManager.storeDropDownSettings(dropDownID, selectedOrNull.getCode());
        }
    }

    public final SampleType tryGetSelectedSampleType() {
        return (SampleType)super.tryGetSelected();
    }

    public void setFilterPattern(String filterPattern) {
        this.filterPattern = filterPattern;
    }

    @Override
    protected List<SampleTypeModel> convertItems(List<SampleType> result) {
        return SampleTypeModel.convert(result, this.onlyListable, this.withAll, this.withTypeInFile);
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<SampleType>> callback) {
        this.viewContext.getCommonService().listSampleTypes(new ListSampleTypesCallback(this.viewContext));
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE_TYPE), DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT)};
    }

    protected void filterTypes(List<SampleType> types) {
        if (this.filterPattern != null) {
            Iterator<SampleType> iterator = types.iterator();
            while (iterator.hasNext()) {
                SampleType type = iterator.next();
                if (type.getCode().matches(this.filterPattern)) continue;
                iterator.remove();
            }
        }
    }

    private void selectInitialValue() {
        if (this.initialCodeOrNull != null) {
            this.trySelectByPropertyValue("code", this.initialCodeOrNull, "Sample Type '" + this.initialCodeOrNull + "' doesn't exist.");
            this.updateOriginalValue();
        }
    }

    private static String tryGetInitialValue(SampleTypeDisplayID displayTypeID, String initialCodeOrNull, DisplaySettingsManager displaySettingsManager) {
        boolean initialCodeExplicitlyDefined;
        boolean bl = initialCodeExplicitlyDefined = initialCodeOrNull != null;
        if (initialCodeExplicitlyDefined) {
            return initialCodeOrNull;
        }
        if (displayTypeID.isSavable()) {
            return displaySettingsManager.getDropDownSettings(displayTypeID.createDisplayID());
        }
        return null;
    }

    private class ListSampleTypesCallback
    extends DropDownList.ListItemsCallback {
        protected ListSampleTypesCallback(IViewContext<?> viewContext) {
            super(SampleTypeSelectionWidget.this, viewContext);
        }

        @Override
        public void process(List<SampleType> result) {
            SampleTypeSelectionWidget.this.filterTypes(result);
            super.process(result);
            SampleTypeSelectionWidget.this.selectInitialValue();
        }
    }
}

