/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.DetailedSearchFieldComboModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PropertyTypeRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.entity.PropertyTypesFilterUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.DropDownList;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ResultSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.AttributeSearchFieldKindProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISearchFieldAvailability;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PersonRoles;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class DetailedSearchFieldsSelectionWidget
extends DropDownList<DetailedSearchFieldComboModel, PropertyType> {
    private static final int WIDTH = 200;
    private static final String EMPTY_RESULT_SUFFIX = "search fields";
    private static final String CHOOSE_SUFFIX = "search field";
    static final String SUFFIX = "data-set-search";
    private final IViewContext<ICommonClientServiceAsync> viewContext;
    private final EntityKind entityKind;
    private boolean dataLoaded;
    private List<PropertyType> propertyTypes;

    public DetailedSearchFieldsSelectionWidget(IViewContext<ICommonClientServiceAsync> viewContext, String idSuffix, EntityKind entityKind) {
        super(viewContext, SUFFIX + idSuffix, "property_type", "code", CHOOSE_SUFFIX, EMPTY_RESULT_SUFFIX);
        this.viewContext = viewContext;
        this.entityKind = entityKind;
        this.dataLoaded = false;
        this.setAllowBlank(true);
    }

    public EntityKind getEntityKind() {
        return this.entityKind;
    }

    @Override
    public PropertyType tryGetSelected() {
        return null;
    }

    public DetailedSearchField tryGetSelectedField() {
        return (DetailedSearchField)GWTUtils.tryGetSingleSelected(this);
    }

    public String tryGetSelectedCode() {
        return GWTUtils.tryGetSingleSelectedCode(this);
    }

    public ISearchFieldKind tryGetSelectedKind() {
        DetailedSearchFieldComboModel model = GWTUtils.tryGetSingleSelectedModel(this);
        return model != null ? model.getKind() : null;
    }

    public List<PropertyType> getAvailablePropertyTypes() {
        return this.propertyTypes;
    }

    public DetailedSearchFieldsSelectionWidget(DetailedSearchFieldsSelectionWidget source, String idSuffix, EntityKind entityKind) {
        this(source.viewContext, idSuffix, entityKind);
        ListStore sourceStore = source.getStore();
        sourceStore.clearFilters();
        this.setValue((ModelData)DetailedSearchFieldsSelectionWidget.findAnyFieldItem(sourceStore.getModels()));
        this.setWidth(200);
        this.setStore(sourceStore);
        this.dataLoaded = true;
    }

    private static DetailedSearchFieldComboModel findAnyFieldItem(List<DetailedSearchFieldComboModel> items) {
        return DetailedSearchFieldsSelectionWidget.findFieldItem(items, DetailedSearchFieldKind.ANY_FIELD);
    }

    private static DetailedSearchFieldComboModel findFieldItem(List<DetailedSearchFieldComboModel> items, DetailedSearchFieldKind fieldKind) {
        for (DetailedSearchFieldComboModel item : items) {
            DetailedSearchField field = item.getField();
            if (field.getKind() != fieldKind) continue;
            return item;
        }
        throw new IllegalStateException("field not found: " + fieldKind);
    }

    @Override
    protected List<DetailedSearchFieldComboModel> convertItems(List<PropertyType> types) {
        ArrayList<DetailedSearchFieldComboModel> result = new ArrayList<DetailedSearchFieldComboModel>();
        IAttributeSearchFieldKind[] iAttributeSearchFieldKindArray = DetailedSearchFieldsSelectionWidget.getAllAttributeFieldKinds(this.entityKind);
        int n = iAttributeSearchFieldKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttributeSearchFieldKind attributeFieldKind = iAttributeSearchFieldKindArray[n2];
            DetailedSearchField attributeField = DetailedSearchField.createAttributeField(attributeFieldKind);
            this.addAttributeFieldComboModel(result, attributeField, attributeFieldKind);
            ++n2;
        }
        Collections.sort(types);
        List<String> allEntityPropertyCodes = this.addEntityPropertyTypes(result, types);
        DetailedSearchField anyPropertyField = DetailedSearchField.createAnyPropertyField(allEntityPropertyCodes);
        this.addComplexFieldComboModel(result, anyPropertyField);
        DetailedSearchField anyField = DetailedSearchField.createAnyField(allEntityPropertyCodes);
        this.addComplexFieldComboModel(result, anyField);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ISearchFieldAvailability availability;
            DetailedSearchFieldComboModel field = (DetailedSearchFieldComboModel)((Object)iterator.next());
            ISearchFieldAvailability iSearchFieldAvailability = availability = field.getKind() != null ? field.getKind().getAvailability() : null;
            if (availability == null || availability.isAvailable(field.getField(), this.getPerson(), this.getPersonRoles())) continue;
            iterator.remove();
        }
        return result;
    }

    private static IAttributeSearchFieldKind[] getAllAttributeFieldKinds(EntityKind entityKind) {
        return AttributeSearchFieldKindProvider.getAllAttributeFieldKinds(entityKind);
    }

    private void addComplexFieldComboModel(List<DetailedSearchFieldComboModel> result, DetailedSearchField field) {
        assert (field.getKind() != DetailedSearchFieldKind.ATTRIBUTE) : "attribute field not allowed";
        result.add(DetailedSearchFieldsSelectionWidget.createComplexFieldComboModel(field));
    }

    private void addAttributeFieldComboModel(List<DetailedSearchFieldComboModel> result, DetailedSearchField attributeField, IAttributeSearchFieldKind attributeFieldKind) {
        assert (attributeField.getKind() == DetailedSearchFieldKind.ATTRIBUTE) : "attribute field required";
        result.add(DetailedSearchFieldsSelectionWidget.createAttributeFieldComboModel(attributeField, attributeFieldKind));
    }

    private static DetailedSearchFieldComboModel createComplexFieldComboModel(DetailedSearchField complexField) {
        assert (complexField.getKind() != DetailedSearchFieldKind.ATTRIBUTE) : "attribute field not allowed";
        return new DetailedSearchFieldComboModel(DetailedSearchFieldsSelectionWidget.getDisplayName(complexField), complexField, null);
    }

    private static DetailedSearchFieldComboModel createAttributeFieldComboModel(DetailedSearchField attributeField, IAttributeSearchFieldKind attributeFieldKind) {
        assert (attributeField.getKind() == DetailedSearchFieldKind.ATTRIBUTE) : "attribute field required";
        return new DetailedSearchFieldComboModel(DetailedSearchFieldsSelectionWidget.getDisplayName(attributeFieldKind), attributeField, attributeFieldKind);
    }

    private List<String> addEntityPropertyTypes(List<DetailedSearchFieldComboModel> result, List<PropertyType> allPropertyTypes) {
        List<PropertyType> relevantPropertyTypes = PropertyTypesFilterUtil.filterPropertyTypesForEntityKind(allPropertyTypes, this.entityKind);
        return DetailedSearchFieldsSelectionWidget.addPropertyTypes(result, relevantPropertyTypes);
    }

    private static List<String> addPropertyTypes(List<DetailedSearchFieldComboModel> result, List<PropertyType> types) {
        ArrayList<String> allProps = new ArrayList<String>();
        for (PropertyType st : types) {
            String propertyCode = st.getCode();
            allProps.add(propertyCode);
            DetailedSearchField field = DetailedSearchField.createPropertyField(propertyCode);
            DetailedSearchFieldComboModel comboModel = DetailedSearchFieldsSelectionWidget.createPropertyComboModel(st, field, types);
            result.add(comboModel);
        }
        return allProps;
    }

    private static DetailedSearchFieldComboModel createPropertyComboModel(PropertyType propertyType, DetailedSearchField searchField, List<PropertyType> types) {
        String prefix = DetailedSearchFieldsSelectionWidget.getDisplayName(searchField);
        String property = PropertyTypeRenderer.getDisplayName(propertyType, types);
        String code = String.valueOf(prefix) + " '" + property + "'";
        return new DetailedSearchFieldComboModel(code, searchField, null);
    }

    private static String getDisplayName(DetailedSearchField complexField) {
        assert (complexField.getKind() != DetailedSearchFieldKind.ATTRIBUTE) : "attribute field not allowed";
        return complexField.getKind().getDescription();
    }

    private static String getDisplayName(IAttributeSearchFieldKind attributefieldKind) {
        return attributefieldKind.getDescription();
    }

    @Override
    protected void loadData(AbstractAsyncCallback<List<PropertyType>> callback) {
        if (!this.dataLoaded) {
            DefaultResultSetConfig<String, TableModelRowWithObject<PropertyType>> config = DefaultResultSetConfig.createFetchAll();
            this.viewContext.getService().listPropertyTypes(config, new ListPropertyTypesCallback(this.viewContext));
        }
        callback.ignore();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE);
    }

    private Person getPerson() {
        return this.viewContext.getModel().getSessionContext().getUser().getUserPersonObject();
    }

    private PersonRoles getPersonRoles() {
        return this.viewContext.getModel().getSessionContext().getUser().getUserPersonRoles();
    }

    private final class ListPropertyTypesCallback
    extends AbstractAsyncCallback<TypedTableResultSet<PropertyType>> {
        ListPropertyTypesCallback(IViewContext<ICommonClientServiceAsync> viewContext) {
            super(viewContext);
        }

        @Override
        protected void process(TypedTableResultSet<PropertyType> result) {
            ResultSet<TableModelRowWithObject<PropertyType>> resultSet = result.getResultSet();
            DetailedSearchFieldsSelectionWidget.this.resultSetKey = resultSet.getResultSetKey();
            List<TableModelRowWithObject<PropertyType>> rows = result.getResultSet().getList().extractOriginalObjects();
            DetailedSearchFieldsSelectionWidget.this.propertyTypes = new ArrayList();
            for (TableModelRowWithObject<PropertyType> row : rows) {
                DetailedSearchFieldsSelectionWidget.this.propertyTypes.add(row.getObjectOrNull());
            }
            ListStore propertyTypeStore = DetailedSearchFieldsSelectionWidget.this.getStore();
            propertyTypeStore.removeAll();
            List<DetailedSearchFieldComboModel> items = DetailedSearchFieldsSelectionWidget.this.convertItems(DetailedSearchFieldsSelectionWidget.this.propertyTypes);
            propertyTypeStore.add(items);
            if (propertyTypeStore.getCount() > 0) {
                DetailedSearchFieldsSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_choose", DetailedSearchFieldsSelectionWidget.CHOOSE_SUFFIX));
                DetailedSearchFieldsSelectionWidget.this.setReadOnly(false);
            } else {
                DetailedSearchFieldsSelectionWidget.this.setEmptyText(this.viewContext.getMessage("combobox_empty", DetailedSearchFieldsSelectionWidget.EMPTY_RESULT_SUFFIX));
                DetailedSearchFieldsSelectionWidget.this.setReadOnly(true);
            }
            DetailedSearchFieldsSelectionWidget.this.setValue((ModelData)DetailedSearchFieldsSelectionWidget.findAnyFieldItem(items));
            DetailedSearchFieldsSelectionWidget.this.dataLoaded = true;
            DetailedSearchFieldsSelectionWidget.this.removeResultSetFromCache();
        }
    }
}

