/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchWindow;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.IDetailedSearchHitGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.TextToolItem;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import java.util.List;
import java.util.Set;

public class DetailedSearchToolbar
extends ToolBar
implements IDisposableComponent {
    private LabelToolItem description;
    private final IDetailedSearchHitGrid grid;
    private final DetailedSearchWindow searchWindow;
    private final boolean shouldShowSearchWindowOnRender;

    public DetailedSearchToolbar(IDetailedSearchHitGrid grid, String buttonName, DetailedSearchWindow searchWindow) {
        this(grid, buttonName, searchWindow, false);
    }

    public DetailedSearchToolbar(IDetailedSearchHitGrid grid, String buttonName, final DetailedSearchWindow searchWindow, boolean initializeDescriptionFromSearchWindow) {
        this.shouldShowSearchWindowOnRender = !initializeDescriptionFromSearchWindow;
        this.grid = grid;
        this.searchWindow = searchWindow;
        this.add((Component)new TextToolItem(buttonName, new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                searchWindow.show();
            }
        }));
        this.add((Component)new SeparatorToolItem());
        this.description = new LabelToolItem();
        this.add((Component)this.description);
        this.add((Component)new FillToolItem());
        if (initializeDescriptionFromSearchWindow) {
            this.updateDescription(searchWindow.getCriteriaDescription());
        }
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return null;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void dispose() {
    }

    public void updateSearchResults(DetailedSearchCriteria searchCriteria, String searchDescription, List<PropertyType> availablePropertyTypes) {
        this.grid.refresh(searchCriteria, availablePropertyTypes);
        this.updateDescription(searchDescription);
    }

    private void updateDescription(String searchDescription) {
        this.description.setLabel(StringUtils.abbreviate(searchDescription, 100));
        GWTUtils.setToolTip((Component)this.description, searchDescription);
    }

    protected void onRender(Element target, int index) {
        super.onRender(target, index);
        if (this.shouldShowSearchWindowOnRender) {
            this.searchWindow.show();
        }
    }
}

