/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchMainCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchSubCriteriaWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.search.DetailedSearchToolbar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AssociatedEntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchSubCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.EventType;
import com.extjs.gxt.ui.client.event.KeyboardEvents;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.layout.FillLayout;
import com.extjs.gxt.ui.client.widget.layout.FitData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

public class DetailedSearchWindow
extends Dialog {
    public static final String SEARCH_BUTTON_ID = "openbis_data-set-search-hit-browsersearch_button";
    private static final Margins MARGINS = new Margins(5, 10, 5, 10);
    private static final int HEIGHT = 400;
    private static final int WIDTH = 550;
    private final DetailedSearchCriteriaWidget criteriaWidget;
    private final List<DetailedSearchSubCriteriaWidget> subCriteriaWidgets = new ArrayList<DetailedSearchSubCriteriaWidget>();
    private DetailedSearchToolbar updateListener;
    private final TabPanel tabPanel;

    public DetailedSearchWindow(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind) {
        this.setPosition(300, 100);
        this.setSize(550, 400);
        this.setModal(true);
        this.setHeading(viewContext.getMessage("search_criteria_dialog_title", entityKind.getDescription()));
        this.setLayout((Layout)new FillLayout());
        this.setResizable(false);
        this.criteriaWidget = new DetailedSearchMainCriteriaWidget(viewContext, entityKind);
        this.add((Component)this.createMainCriteriaPanel());
        this.tabPanel = new TabPanel();
        for (AssociatedEntityKind association : DetailedSearchWindow.getAssociatedEntityKinds(entityKind)) {
            DetailedSearchSubCriteriaWidget subCriteriaWidget = new DetailedSearchSubCriteriaWidget(viewContext, association);
            this.subCriteriaWidgets.add(subCriteriaWidget);
            this.addSearchWidgetTab(subCriteriaWidget);
        }
        if (!this.subCriteriaWidgets.isEmpty()) {
            this.add((Component)this.tabPanel);
        }
        this.addEnterListener();
        ButtonBar bar = this.getButtonBar();
        bar.removeAll();
        bar.add((Component)new Button(viewContext.getMessage("button_cancel", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DetailedSearchWindow.this.hide();
            }
        }));
        bar.add((Component)new Button(viewContext.getMessage("button_reset", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                for (DetailedSearchCriteriaWidget widget : DetailedSearchWindow.this.getAllWidgets()) {
                    widget.reset();
                }
            }
        }));
        Button searchButton = new Button(viewContext.getMessage("search_button", new Object[0]), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DetailedSearchWindow.this.onSearch();
            }
        });
        searchButton.setId(SEARCH_BUTTON_ID);
        bar.add((Component)searchButton);
        DialogWithOnlineHelpUtils.addHelpButton(viewContext, (Window)this, this.createHelpPageIdentifier(entityKind));
    }

    private ContentPanel createMainCriteriaPanel() {
        ContentPanel mainPanel = new ContentPanel();
        mainPanel.setHeaderVisible(false);
        mainPanel.setLayout((Layout)new FitLayout());
        mainPanel.setScrollMode(Style.Scroll.AUTOY);
        mainPanel.add((Widget)this.criteriaWidget, (LayoutData)new FitData(MARGINS));
        return mainPanel;
    }

    private void addSearchWidgetTab(DetailedSearchSubCriteriaWidget searchWidget) {
        TabItem tab = new TabItem();
        tab.setClosable(false);
        tab.setLayout((Layout)new FitLayout());
        tab.setScrollMode(Style.Scroll.AUTOY);
        tab.setText(searchWidget.getCriteriaLabel());
        tab.add((Widget)searchWidget, (LayoutData)new FitData(MARGINS));
        tab.setHideMode(Style.HideMode.OFFSETS);
        this.tabPanel.add(tab);
    }

    private List<DetailedSearchCriteriaWidget> getAllWidgets() {
        ArrayList<DetailedSearchCriteriaWidget> result = new ArrayList<DetailedSearchCriteriaWidget>(this.subCriteriaWidgets);
        result.add((DetailedSearchSubCriteriaWidget)this.criteriaWidget);
        return result;
    }

    private void addEnterListener() {
        for (DetailedSearchCriteriaWidget widget : this.getAllWidgets()) {
            widget.addListener(KeyboardEvents.Enter, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent ce) {
                    EventType type = ce.getType();
                    switch (type.getEventCode()) {
                        case 13: {
                            DetailedSearchWindow.this.onSearch();
                            break;
                        }
                    }
                }
            });
        }
    }

    protected void afterShow() {
        super.afterShow();
        this.criteriaWidget.focus();
    }

    public DetailedSearchCriteria tryGetCriteria() {
        DetailedSearchCriteria mainCriteria = this.criteriaWidget.extractCriteria();
        for (DetailedSearchSubCriteriaWidget subCriteriaWidget : this.subCriteriaWidgets) {
            if (!subCriteriaWidget.isCriteriaFilled()) continue;
            DetailedSearchSubCriteria subCriteria = subCriteriaWidget.extractSubCriteria();
            mainCriteria.addSubCriteria(subCriteria);
        }
        if (mainCriteria.isEmpty()) {
            return null;
        }
        return mainCriteria;
    }

    public String getCriteriaDescription() {
        StringBuilder sb = new StringBuilder();
        if (this.criteriaWidget.isCriteriaFilled()) {
            sb.append(this.criteriaWidget.getCriteriaDescription());
        }
        for (DetailedSearchCriteriaWidget detailedSearchCriteriaWidget : this.subCriteriaWidgets) {
            if (!detailedSearchCriteriaWidget.isCriteriaFilled()) continue;
            sb.append(", ");
            sb.append(detailedSearchCriteriaWidget.getCriteriaDescription());
        }
        if (!this.criteriaWidget.isCriteriaFilled()) {
            sb.delete(0, 2);
        }
        return sb.toString();
    }

    public void setUpdateListener(DetailedSearchToolbar toolbar) {
        this.updateListener = toolbar;
    }

    protected HelpPageIdentifier createHelpPageIdentifier(EntityKind entityKind) {
        return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.SEARCH, HelpPageIdentifier.HelpPageAction.ACTION);
    }

    public void setInitialSearchCriteria(DetailedSearchCriteria searchCriteria) {
        this.criteriaWidget.setInitialSearchCritera(searchCriteria);
    }

    private void onSearch() {
        this.hide();
        List<PropertyType> availablePropertyTypes = this.criteriaWidget.getAvailablePropertyTypes();
        DetailedSearchCriteria criteria = this.tryGetCriteria();
        String criteriaDescription = this.getCriteriaDescription();
        this.updateListener.updateSearchResults(criteria, criteriaDescription, availablePropertyTypes);
    }

    private static List<AssociatedEntityKind> getAssociatedEntityKinds(EntityKind sourceEntity) {
        return AssociatedEntityKind.getAssociatedEntityKinds(sourceEntity);
    }
}

