/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ComponentProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DefaultTabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.ITabItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.renderer.PersonRenderer;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyListDeletionConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyRegistrationFieldSet;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary.VocabularyTermGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;

public class VocabularyGrid
extends TypedTableGrid<Vocabulary> {
    public static final String BROWSER_ID = "openbis_vocabulary-browser";
    public static final String GRID_ID = "openbis_vocabulary-browser-grid";
    public static final String SHOW_DETAILS_BUTTON_ID = "openbis_vocabulary-browser_show-details-button";
    public static final String ADD_BUTTON_ID = "openbis_vocabulary-browser_add-button";
    public static final String DELETE_BUTTON_ID = "openbis_vocabulary-browser_delete-button";
    private final IDelegatedAction postEditionCallback = this.createRefreshGridAction();

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        VocabularyGrid grid = new VocabularyGrid(viewContext);
        grid.extendBottomToolbar();
        return grid.asDisposableWithoutToolbar();
    }

    private VocabularyGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.VOCABULARY_BROWSER_GRID);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<Vocabulary>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<Vocabulary>> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).listVocabularies(false, false, resultSetConfig, callback);
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<Vocabulary>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<Vocabulary>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("CODE", this.createInternalLinkCellRenderer());
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        schema.setGridCellRendererFor("REGISTRATOR", PersonRenderer.REGISTRATOR_RENDERER);
        return schema;
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("CODE");
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<Vocabulary>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportVocabularies(exportCriteria, callback);
    }

    @Override
    protected void showEntityViewer(final TableModelRowWithObject<Vocabulary> vocabulary, boolean editMode, boolean inBackground) {
        AbstractTabItemFactory tabFactory = new AbstractTabItemFactory(){

            @Override
            public ITabItem create() {
                IDisposableComponent component = VocabularyTermGrid.create(VocabularyGrid.this.viewContext, (Vocabulary)vocabulary.getObjectOrNull());
                return DefaultTabItem.create(this.getTabTitle(), component, VocabularyGrid.this.viewContext);
            }

            @Override
            public String getId() {
                return VocabularyTermGrid.createBrowserId((Vocabulary)vocabulary.getObjectOrNull());
            }

            @Override
            public HelpPageIdentifier getHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.TERM, HelpPageIdentifier.HelpPageAction.BROWSE);
            }

            @Override
            public String getTabTitle() {
                return VocabularyGrid.this.viewContext.getMessage("VOCABULARY_TERMS_BROWSER", ((Vocabulary)vocabulary.getObjectOrNull()).getCode());
            }

            @Override
            public String tryGetLink() {
                return null;
            }
        };
        tabFactory.setInBackground(inBackground);
        DispatcherHelper.dispatchNaviEvent(tabFactory);
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button addButton = new Button(this.viewContext.getMessage("button_add", "Vocabulary"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                DispatcherHelper.dispatchNaviEvent(new ComponentProvider(VocabularyGrid.this.viewContext).getVocabularyRegistration());
            }
        });
        addButton.setId(ADD_BUTTON_ID);
        this.addButton(addButton);
        Button showDetailsButton = this.createSelectedItemButton(this.viewContext.getMessage("button_show_details", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<Vocabulary>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<Vocabulary>> selectedItem, boolean keyPressed) {
                VocabularyGrid.this.showEntityViewer(selectedItem.getBaseObject(), false, keyPressed);
            }
        });
        showDetailsButton.setId(SHOW_DETAILS_BUTTON_ID);
        this.addButton(showDetailsButton);
        this.addButton(this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<Vocabulary>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<Vocabulary>> selectedItem, boolean keyPressed) {
                Vocabulary vocabulary = selectedItem.getBaseObject().getObjectOrNull();
                if (vocabulary.isManagedInternally()) {
                    String errorMsg = "Internally managed vocabulary cannot be edited.";
                    MessageBox.alert((String)"Error", (String)errorMsg, null);
                } else {
                    VocabularyGrid.this.createEditEntityDialog(vocabulary).show();
                }
            }
        }));
        Button deleteButton = this.createSelectedItemsButton(this.viewContext.getMessage("button_delete", new Object[0]), new TypedTableGrid.AbstractCreateDialogListener(this){

            protected Dialog createDialog(List<TableModelRowWithObject<Vocabulary>> vocabularies, IBrowserGridActionInvoker invoker) {
                return new VocabularyListDeletionConfirmationDialog(VocabularyGrid.this.viewContext, vocabularies, VocabularyGrid.this.createRefreshCallback(invoker));
            }

            protected boolean validateSelectedData(List<TableModelRowWithObject<Vocabulary>> data) {
                String errorMsg = "Internally managed vocabularies cannot be deleted.";
                for (TableModelRowWithObject<Vocabulary> vocabulary : data) {
                    if (!vocabulary.getObjectOrNull().isManagedInternally()) continue;
                    MessageBox.alert((String)"Error", (String)errorMsg, null);
                    return false;
                }
                return true;
            }
        });
        deleteButton.setId(DELETE_BUTTON_ID);
        this.addButton(deleteButton);
        this.allowMultipleSelection();
        this.addEntityOperationsSeparator();
    }

    private Component createEditEntityDialog(final Vocabulary vocabulary) {
        String title = this.viewContext.getMessage("edit_title", "vocabulary", vocabulary.getCode());
        return new AbstractRegistrationDialog(this.viewContext, title, this.postEditionCallback){
            private final TextField<String> codeField;
            private final DescriptionField descriptionField;
            private final TextField<String> urlTemplateField;
            private static final int LABEL_WIDTH = 100;
            private static final int FIELD_WIDTH = 350;
            private final CheckBox chosenFromList;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.form.setLabelWidth(100);
                this.form.setFieldWidth(350);
                this.setWidth(500);
                this.codeField = this.createMandatoryCodeField();
                this.codeField.setValue((Object)this.getOldVocabularyCode());
                this.addField((Widget)this.codeField);
                this.descriptionField = 6.createDescriptionField(VocabularyGrid.this.viewContext);
                FieldUtil.setValueWithUnescaping((Field<String>)this.descriptionField, vocabulary2.getDescription());
                this.addField((Widget)this.descriptionField);
                String urlTemplate = vocabulary2.getURLTemplate();
                if (urlTemplate != null) {
                    urlTemplate = urlTemplate.replaceAll(BasicConstant.DEPRECATED_VOCABULARY_URL_TEMPLATE_TERM_PATTERN, BasicConstant.VOCABULARY_URL_TEMPLATE_TERM_PATTERN);
                }
                this.urlTemplateField = this.createURLTemplateField();
                FieldUtil.setValueWithUnescaping(this.urlTemplateField, urlTemplate);
                this.addField((Widget)this.urlTemplateField);
                this.chosenFromList = this.createChosenFromListCheckbox();
                FieldUtil.setValueWithoutEvents(this.chosenFromList, vocabulary2.isChosenFromList());
                this.addField((Widget)this.chosenFromList);
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                vocabulary.setCode((String)this.codeField.getValue());
                vocabulary.setDescription((String)this.descriptionField.getValue());
                vocabulary.setURLTemplate((String)this.urlTemplateField.getValue());
                vocabulary.setChosenFromList(this.chosenFromList.getValue());
                ((ICommonClientServiceAsync)VocabularyGrid.this.viewContext.getService()).updateVocabulary(vocabulary, registrationCallback);
            }

            private TextField<String> createMandatoryCodeField() {
                return VocabularyRegistrationFieldSet.CommonVocabularyRegistrationAndEditionFieldsFactory.createCodeField(VocabularyGrid.this.viewContext);
            }

            private TextField<String> createURLTemplateField() {
                return VocabularyRegistrationFieldSet.CommonVocabularyRegistrationAndEditionFieldsFactory.createURLTemplateField(VocabularyGrid.this.viewContext);
            }

            private CheckBox createChosenFromListCheckbox() {
                return VocabularyRegistrationFieldSet.CommonVocabularyRegistrationAndEditionFieldsFactory.createChosenFromListCheckbox(VocabularyGrid.this.viewContext);
            }

            private String getOldVocabularyCode() {
                return StringEscapeUtils.unescapeHtml(vocabulary.getCode());
            }
        };
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.VOCABULARY)};
    }
}

