/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.vocabulary;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CodeField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTerm;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class VocabularyTermValidator
implements Validator {
    private final IMessageProvider messageProvider;
    private final Set<String> existingTerms;

    VocabularyTermValidator(IMessageProvider messageProvider) {
        this(messageProvider, Collections.emptyList());
    }

    public VocabularyTermValidator(IMessageProvider messageProvider, List<VocabularyTerm> terms) {
        this.messageProvider = messageProvider;
        this.existingTerms = new HashSet<String>();
        for (VocabularyTerm vocabularyTerm : terms) {
            this.existingTerms.add(vocabularyTerm.getCode());
        }
    }

    static final List<VocabularyTerm> getTerms(String value) {
        ArrayList<VocabularyTerm> terms = new ArrayList<VocabularyTerm>();
        if (!StringUtils.isBlank(value)) {
            String[] split;
            String[] stringArray = split = value.split("[,\n\r\t\f ]");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String text = stringArray[n2];
                if (!StringUtils.isBlank(text)) {
                    VocabularyTerm term = new VocabularyTerm();
                    term.setCode(text);
                    terms.add(term);
                }
                ++n2;
            }
        }
        return terms;
    }

    public final String validate(Field<?> field, String value) {
        List<VocabularyTerm> terms = VocabularyTermValidator.getTerms(value);
        if (terms.size() == 0) {
            return this.messageProvider.getMessage("missing_vocabulary_terms", new Object[0]);
        }
        for (VocabularyTerm term : terms) {
            CodeField.CodeFieldKind codeKind = CodeField.CodeFieldKind.CODE_WITH_COLON;
            if (!term.getCode().matches(codeKind.getPattern())) {
                return this.messageProvider.getMessage("invalid_code_message", codeKind.getAllowedCharacters());
            }
            if (!this.existingTerms.contains(term.getCode().toUpperCase())) continue;
            return this.messageProvider.getMessage("vocabulary_terms_validation_message", term);
        }
        return null;
    }
}

