/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.google.gwt.user.client.Element;

public abstract class AbstractDataConfirmationDialog<T>
extends Dialog {
    protected final IMessageProvider messageProvider;
    protected final T data;
    protected final FormPanel formPanel;
    protected final LabelField messageField;
    protected final KeyListener keyListener;

    protected AbstractDataConfirmationDialog(IMessageProvider messageProvider, T data, String title) {
        this.messageProvider = messageProvider;
        this.data = data;
        this.initializeData();
        this.setHeading(title);
        this.setButtons("okcancel");
        this.setHideOnButtonClick(true);
        this.setModal(true);
        this.messageField = new LabelField();
        this.messageField.setStyleName("message");
        this.formPanel = this.createForm();
        this.keyListener = new KeyListener(){

            public void handleEvent(ComponentEvent ce) {
                AbstractDataConfirmationDialog.this.updateOkButtonState();
            }
        };
    }

    protected abstract String createMessage();

    protected abstract void extendForm();

    protected abstract void executeConfirmedAction();

    protected void initializeData() {
    }

    protected final void updateOkButtonState() {
        Component okButtonOrNull = this.getItemByItemId("ok");
        if (okButtonOrNull != null) {
            okButtonOrNull.setEnabled(this.validate());
        }
    }

    protected boolean validate() {
        return this.formPanel.isValid();
    }

    private FormPanel createForm() {
        FormPanel form = new FormPanel();
        form.setBodyBorder(false);
        form.setHeaderVisible(false);
        return form;
    }

    protected final void onButtonPressed(Button button) {
        if (button.getItemId().equals("ok")) {
            button.disable();
            if (this.validate()) {
                this.executeConfirmedAction();
                super.onButtonPressed(button);
            } else {
                button.enable();
            }
        } else {
            super.onButtonPressed(button);
        }
    }

    protected void onRender(Element parent, int pos) {
        super.onRender(parent, pos);
        this.add((Component)this.messageField);
        this.extendForm();
        this.refreshMessage();
        this.add((Component)this.formPanel);
        this.updateOkButtonState();
    }

    protected final void refreshMessage() {
        this.messageField.setText(this.createMessage());
    }

    protected final IDelegatedAction createRefreshMessageAction() {
        return new IDelegatedAction(){

            @Override
            public void execute() {
                AbstractDataConfirmationDialog.this.refreshMessage();
            }
        };
    }
}

