/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ReasonField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractDataConfirmationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WidgetUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DeletionType;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;

public abstract class AbstractDataListDeletionConfirmationDialog<T>
extends AbstractDataConfirmationDialog<List<T>> {
    private static final int LABEL_WIDTH = 70;
    private static final int FIELD_WIDTH = 180;
    private static final String ALL_EMPHASIZED = "<b>ALL</b> displayed ";
    private static final String SELECTED = " selected ";
    protected final IViewContext<?> viewContext;
    private final AsyncCallback<Void> deletionCallback;
    private boolean withRadio = false;
    protected Radio onlySelectedRadioOrNull;
    protected ReasonField reason;

    public AbstractDataListDeletionConfirmationDialog(IViewContext<?> viewContext, List<T> data, AsyncCallback<Void> deletionCallback) {
        super(viewContext, data, viewContext.getMessage("delete_confirmation_title", new Object[0]));
        this.viewContext = viewContext;
        this.deletionCallback = deletionCallback;
    }

    protected void withRadio() {
        this.withRadio = true;
    }

    @Override
    protected void extendForm() {
        this.formPanel.setLabelWidth(70);
        this.formPanel.setFieldWidth(180);
        this.reason = new ReasonField(this.messageProvider, true);
        this.reason.setId("deletion-reason");
        this.reason.focus();
        this.reason.addKeyListener(this.keyListener);
        if (this.withRadio) {
            this.formPanel.add((Widget)this.createRadio());
        }
        this.formPanel.add((Widget)this.reason);
    }

    @Override
    protected String createMessage() {
        String deletedObjects = !this.withRadio ? String.valueOf(((List)this.data).size()) + " " + this.getEntityName() : String.valueOf(this.isOnlySelected() ? String.valueOf(((List)this.data).size()) + SELECTED : ALL_EMPHASIZED) + this.getEntityName();
        return this.messageProvider.getMessage("delete_confirmation_message_with_reason_template", this.getOperationName(), deletedObjects);
    }

    protected abstract String getEntityName();

    protected abstract void executeDeletion(AsyncCallback<Void> var1);

    protected DeletionType getDeletionType() {
        return this.isTrashEnabled() ? DeletionType.TRASH : DeletionType.PERMANENT;
    }

    String getOperationName() {
        String dictKey = this.isTrashEnabled() ? "deleting" : "deleting_permanently";
        return this.viewContext.getMessage(dictKey, new Object[0]);
    }

    String getProgressMessage() {
        String dictKey = this.isTrashEnabled() ? "delete_progress_message" : "delete_permanently_progress_message";
        return this.viewContext.getMessage(dictKey, this.getEntityName());
    }

    protected final boolean isTrashEnabled() {
        return this.viewContext.getModel().getApplicationInfo().getWebClientConfiguration().getEnableTrash();
    }

    @Override
    protected final void executeConfirmedAction() {
        this.executeDeletion(this.getCallbackWithProgressBar());
    }

    protected RadioGroup createRadio() {
        return null;
    }

    protected final boolean isOnlySelected() {
        return WidgetUtils.isSelected(this.onlySelectedRadioOrNull);
    }

    private AsyncCallback<Void> getCallbackWithProgressBar() {
        return AsyncCallbackWithProgressBar.decorate(this.deletionCallback, this.getProgressMessage());
    }
}

