/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.common.shared.basic.string.StringUtils;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.TableRowLayout;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public abstract class ButtonWithLoadingMask
extends LayoutContainer {
    private static final String LOADING_IMAGE_URL = "images/loading.gif";
    private final Button button;
    private final Image loadingImage;

    public ButtonWithLoadingMask(String buttonLabel, String buttonIdOrNull) {
        this(buttonLabel, buttonIdOrNull, Style.Direction.RIGHT);
    }

    public ButtonWithLoadingMask(String buttonLabel, String buttonIdOrNull, Style.Direction loadingMaskDirection) {
        super((Layout)ButtonWithLoadingMask.createLayout());
        this.assertDirection(loadingMaskDirection);
        this.button = this.createButton(buttonLabel, buttonIdOrNull, loadingMaskDirection);
        this.loadingImage = ButtonWithLoadingMask.createLoadingImage();
        if (loadingMaskDirection == Style.Direction.RIGHT) {
            this.add((Component)this.button);
            this.add((Widget)this.loadingImage);
        } else {
            this.add((Widget)this.loadingImage);
            this.add((Component)this.button);
        }
        this.layout();
    }

    private final void assertDirection(Style.Direction direction) {
        if (direction == Style.Direction.LEFT || direction == Style.Direction.RIGHT) {
            return;
        }
        throw new IllegalArgumentException("Only LEFT or RIGHT are supported.");
    }

    private static final TableRowLayout createLayout() {
        TableRowLayout tableRowLayout = new TableRowLayout();
        tableRowLayout.setBorder(0);
        tableRowLayout.setCellPadding(0);
        tableRowLayout.setCellSpacing(0);
        return tableRowLayout;
    }

    private final Button createButton(String buttonLabel, String buttonIdOrNull, Style.Direction direction) {
        assert (buttonLabel != null) : "Unspecified button label.";
        Button but = new Button(buttonLabel);
        if (!StringUtils.isBlank(buttonIdOrNull)) {
            but.setId(buttonIdOrNull);
        }
        but.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                ButtonWithLoadingMask.this.doButtonClick();
            }
        });
        String attributeName = direction == Style.Direction.LEFT ? "marginLeft" : "marginRight";
        but.setStyleAttribute(attributeName, "3px");
        return but;
    }

    private static final Image createLoadingImage() {
        Image image = new Image(LOADING_IMAGE_URL);
        image.setVisible(false);
        return image;
    }

    public abstract void doButtonClick();

    public final Button getButton() {
        return this.button;
    }

    public final void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
        this.loadingImage.setVisible(!enabled);
    }
}

