/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.GWTUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.lang.StringEscapeUtils;
import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.WidgetComponent;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.LabelField;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class FieldUtil {
    private static final int[] INFO_LINK_FIELD_OFFSETS = new int[]{20, 3};
    private static final String INFO_LINK_POSITION = "tl-tr";
    private static final String MANDATORY_LABEL_SEPARATOR = ":&nbsp;*";

    public static void setMandatoryFlag(Field<?> field, boolean isMandatory) {
        if (isMandatory) {
            FieldUtil.markAsMandatory(field);
        }
    }

    public static void setMandatoryFlag(TextField<?> field, boolean isMandatory) {
        if (isMandatory) {
            FieldUtil.markAsMandatory(field);
        } else {
            field.setAllowBlank(true);
        }
    }

    public static void markAsMandatory(TextField<?> field) {
        FieldUtil.markAsMandatory(field);
        field.setAllowBlank(false);
    }

    public static void markAsMandatory(Field<?> field) {
        field.setLabelSeparator(MANDATORY_LABEL_SEPARATOR);
    }

    public static void setVisibility(boolean visible, Field<?> ... fields) {
        Field<?>[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field<?> field = fieldArray[n2];
            FieldUtil.setVisibility(field, visible);
            ++n2;
        }
    }

    private static void setVisibility(Field<?> field, boolean visible) {
        field.setEnabled(visible);
        field.setVisible(visible);
        field.syncSize();
        if (!visible) {
            field.clearInvalid();
        } else if (field.isDirty()) {
            field.validate();
        }
    }

    public static <T> void setValueWithoutEvents(Field<T> field, T value) {
        field.enableEvents(false);
        field.setValue(value);
        field.enableEvents(true);
    }

    public static void setValueWithUnescaping(Field<String> field, String value) {
        field.setValue((Object)StringEscapeUtils.unescapeHtml(value));
    }

    public static void setValueWithUnescaping(LabelField field, String value) {
        field.setValue((Object)StringEscapeUtils.unescapeHtml(value));
    }

    public static void addInfoIcon(Field<?> field, String message, Image image) {
        FieldUtil.addInfoIcon(field, message, image, INFO_LINK_FIELD_OFFSETS);
    }

    public static void addInfoIcon(Field<?> field, String message, Image image, int xOffset, int yOffset) {
        FieldUtil.addInfoIcon(field, message, image, new int[]{xOffset, yOffset});
    }

    private static void addInfoIcon(final Field<?> field, String message, Image image, final int[] infoLinkFieldOffsets) {
        final WidgetComponent infoIcon = FieldUtil.createInfoIcon(message, image);
        final IDelegatedAction alignInfoIcon = new IDelegatedAction(){

            @Override
            public void execute() {
                infoIcon.el().alignTo(field.getElement(), FieldUtil.INFO_LINK_POSITION, infoLinkFieldOffsets);
            }
        };
        field.addListener(Events.Render, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                Element parent = field.el().getParent().dom;
                infoIcon.render(parent);
                infoIcon.setStyleAttribute("display", "block");
                infoIcon.el().makePositionable(true);
                if (!infoIcon.isAttached()) {
                    ComponentHelper.doAttach((Widget)infoIcon);
                }
                GWTUtils.executeDelayed(alignInfoIcon);
                if (GXT.isIE || GXT.isOpera) {
                    GWTUtils.executeDelayed(alignInfoIcon);
                }
                field.el().repaint();
            }
        });
        field.addListener(Events.Show, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                if (field.isRendered()) {
                    GWTUtils.executeDelayed(alignInfoIcon);
                    if (GXT.isIE || GXT.isOpera) {
                        GWTUtils.executeDelayed(alignInfoIcon);
                    }
                }
            }
        });
    }

    private static WidgetComponent createInfoIcon(final String message, Image image) {
        WidgetComponent info = new WidgetComponent((Widget)image);
        info.setStyleName("hands");
        info.setStyleAttribute("cursor", "hand");
        GWTUtils.setToolTip((Component)info, message);
        info.sinkEvents(Events.OnClick.getEventCode());
        info.addListener(Events.OnClick, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent e) {
                MessageBox.info((String)"Info", (String)message, null);
            }
        });
        return info;
    }
}

